/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.iterable.ListIterable;


/**
 * This interface defines all properties and behavior associated with named query configuration in
 * the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.NamedQuery
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalNamedQuery extends ExternalForm {

	/**
	 * Adds a hint with the given name.
	 */
	void addQueryHint(int index, String name, String value);

	/**
	 * Returns the description of query.
	 */
	String getDescription();

	/**
	 * Returns the position of this named query within the list of named queries owned by the parent.
	 */
	int getIndex();

	/**
	 * Returns the name of the query.
	 */
	String getName();

	/**
	 * Returns the string representing the JPAQL (EJBQL) for the queries expression.
	 */
	String getQuery();

	/**
	 * Returns the query hint at the given position.
	 */
	ExternalQueryHint getQueryHint(int index);

	/**
	 * Returns a list of vender specific query hints associated with this query.
	 */
	ListIterable<ExternalQueryHint> queryHints();

	/**
	 * Returns the count of vender specific query hints associated with this query.
	 */
	int queryHintsSize();

	/**
	 * Removes the hint named.
	 */
	void removeQueryHint(int index);

	/**
	 * Sets the description.
	 */
	void setDescription(String description);

	/**
	 * Sets the name of the query.
	 */
	void setName(String name);

	/**
	 * Sets the string representing the JPAQL for the queries expression.
	 */
	void setQuery(String query);
}