/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface and inherited behavior describes the configurable properties for an property. One
 * or more property can be declared as part of an entity
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.Property
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalProperty extends ExternalForm {

	/**
	 * Returns the index of this element in its owning parent.
	 */
	int getIndex();

	/**
	 * Returns the name of the property.
	 */
	String getName();

	/**
	 * Returns the value string for this property.
	 */
	String getValue();

	/**
	 * Returns the value type string for this property.
	 */
	String getValueType();

	/**
	 * Sets the name for the this property.
	 */
	void setName(String name);

	/**
	 * Sets the value string for this property.
	 */
	void setValue(String value);

	/**
	 * Sets the value type string for this property.
	 */
	void setValueType(String valueType);
}