/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClass;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class AttributePool {
    private ClassFile classFile;
    private short count;
    private Attribute[] attributes;
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    AttributePool(ClassFileDataInputStream stream, ClassFile classFile) throws IOException {
        this.classFile = classFile;
        this.initialize(stream);
    }

    private void initialize(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        Attribute[] localAttributes = this.attributes = new Attribute[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localAttributes[i] = Attribute.read(stream, this);
        }
    }

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        if (cnt == 0) {
            return;
        }
        writer.print("Attribute Pool (count: ");
        writer.print(cnt);
        writer.println(')');
        writer.indent();
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            localAttributes[i].displayStringOn(writer);
        }
        writer.undent();
    }

    public InnerClass innerClassNamed(String className) {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            InnerClass innerClass = localAttributes[i].innerClassNamed(className);
            if (innerClass == null) continue;
            return innerClass;
        }
        throw new IllegalArgumentException(className);
    }

    public Object fieldConstantValue() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            Object value = localAttributes[i].fieldConstantValue();
            if (value == null) continue;
            return value;
        }
        throw new IllegalStateException();
    }

    public void printFieldInitializationClauseOn(PrintWriter writer) {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localAttributes[i].printFieldInitializationClauseOn(writer);
        }
    }

    public String[] exceptionClassNames() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            String[] exceptionClassNames = localAttributes[i].exceptionClassNames();
            if (exceptionClassNames == null) continue;
            return exceptionClassNames;
        }
        return EMPTY_STRING_ARRAY;
    }

    public String declaringClassName() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            String declaringClassName = localAttributes[i].declaringClassName();
            if (declaringClassName == null) continue;
            return declaringClassName;
        }
        return null;
    }

    public String nestedClassName() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            String nestedClassName = localAttributes[i].nestedClassName();
            if (nestedClassName == null) continue;
            return nestedClassName;
        }
        return null;
    }

    public short nestedClassAccessFlags() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            short nestedClassAccessFlags = localAttributes[i].nestedClassAccessFlags();
            if (nestedClassAccessFlags == 0) continue;
            return nestedClassAccessFlags;
        }
        return 0;
    }

    public String[] nestedClassNames() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            String[] nestedClassNames = localAttributes[i].nestedClassNames();
            if (nestedClassNames == null) continue;
            return nestedClassNames;
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] declaredMemberClassNames() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            String[] declaredMemberClassNames = localAttributes[i].declaredMemberClassNames();
            if (declaredMemberClassNames == null) continue;
            return declaredMemberClassNames;
        }
        return EMPTY_STRING_ARRAY;
    }

    public void printThrowsClauseOn(PrintWriter writer) {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localAttributes[i].printThrowsClauseOn(writer);
        }
    }

    public boolean isDeprecated() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            if (!localAttributes[i].isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public boolean isSynthetic() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            if (!localAttributes[i].isSynthetic()) continue;
            return true;
        }
        return false;
    }

    public boolean isNestedClass() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            if (!localAttributes[i].isNestedClass()) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberClass() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            if (!localAttributes[i].isMemberClass()) continue;
            return true;
        }
        return false;
    }

    public boolean isLocalClass() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            if (!localAttributes[i].isLocalClass()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnonymousClass() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            if (!localAttributes[i].isAnonymousClass()) continue;
            return true;
        }
        return false;
    }

    public String sourceFileName() {
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            String sourceFileName = localAttributes[i].sourceFileName();
            if (sourceFileName == null) continue;
            return sourceFileName;
        }
        return EMPTY_STRING;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public ConstantPool constantPool() {
        return this.classFile.getConstantPool();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        Attribute[] localAttributes = this.attributes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localAttributes[i].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public Attribute get(short index) {
        return this.attributes[index];
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " attribute(s))";
    }
}

