/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.sessionbean;

import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.persistence.EntityManager;
import javax.rmi.PortableRemoteObject;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.FormerEmployment;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService;
import org.eclipse.persistence.testing.tests.jpa.sessionbean.FindAllThread;

public class SessionBeanHATests
extends JUnitTestCase {
    protected EmployeeService service;
    static ServerSession serverSession;
    static int jtaCount;
    static int nonJTACount;

    public SessionBeanHATests() {
    }

    public SessionBeanHATests(String name) {
        super(name);
    }

    public SessionBeanHATests(String name, boolean shouldRunTestOnServer) {
        super(name);
        this.shouldRunTestOnServer = shouldRunTestOnServer;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SessionBeanHATests");
        suite.addTest((Test)new SessionBeanHATests("testUpdate", false));
        return suite;
    }

    public void testSetup() throws Exception {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"sessionbean"));
        for (int i = 1; i <= jtaCount; ++i) {
            Employee bob = new Employee();
            bob.setFirstName("Bob");
            String lastName = "" + System.currentTimeMillis();
            bob.setLastName(lastName);
            bob.setAddress(new Address());
            bob.setDepartment(new Department());
            this.getEmployeeService().insert(bob);
        }
    }

    public void testFindAll() throws Exception {
        int repeatTimes = 50;
        for (int i = 1; i <= repeatTimes; ++i) {
            try {
                System.out.println("===FindAll iteration " + i);
                List result = this.getEmployeeService().findAll();
                int employCount = 0;
                for (Employee employee : result) {
                    ++employCount;
                }
                if (employCount != jtaCount) {
                    SessionBeanHATests.fail((String)("The count is " + employCount + ", Failed to find all employees"));
                }
                Thread.currentThread();
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception e) {
                SessionBeanHATests.fail((String)e.toString());
            }
        }
    }

    public void testFindAllNonJTA() throws Exception {
        int repeatTimes = 121;
        for (int i = 1; i <= repeatTimes; ++i) {
            EntityManager em = SessionBeanHATests.getServerPlatform().getEntityManagerFactory("sessionbean").createEntityManager();
            try {
                System.out.println("===FindAllNonJTA iteration " + i);
                List result = em.createQuery("Select e from Employee e").getResultList();
                int employCount = 0;
                for (Employee employee : result) {
                    ++employCount;
                }
                if (employCount != nonJTACount) {
                    SessionBeanHATests.fail((String)("The count is " + employCount + ", Failed to find all employees"));
                }
                Thread.currentThread();
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception e) {
                SessionBeanHATests.fail((String)e.toString());
            }
        }
    }

    public void testUpdate() throws Exception {
        Employee employee = new Employee();
        employee.setFirstName("Bob");
        employee.setLastName("Smith");
        Employee manager = new Employee();
        manager.setFirstName("Jon");
        manager.setLastName("Way");
        employee.setAddress(new Address());
        employee.getAddress().setCity("Nepean");
        employee.setManager(manager);
        int id = this.getEmployeeService().insert(employee);
        int repeatTimes = 60;
        int exceptTimes = 0;
        for (int i = 1; i <= repeatTimes; ++i) {
            try {
                System.out.println("===Update iteration " + i);
                employee = this.getEmployeeService().findById(id);
                employee.setFirstName("Small Romantic Moon Over The Lake");
                employee.setLastName("Big White Horse who gallops the grass");
                Address address = new Address();
                address.setCountry("Canada");
                address.setProvince("Newfoundland and Labrador");
                address.setCity("Harbour Main-Chapel Cove-Lakeview");
                address.setStreet("96 Brownskill");
                address.setPostalCode("K1P1A6");
                employee.setAddress(address);
                employee.setMale();
                employee.setSalary(150000);
                employee.setRoomNumber(407);
                Department dept = new Department();
                dept.setName("Software Quality Assurance");
                dept.addManager(employee);
                employee.setDepartment(dept);
                Vector<String> reps = new Vector<String>(2);
                reps.add("scrum everyday, weekly status report and abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz");
                reps.add("unit test, integration and system test abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz");
                employee.setResponsibilities(reps);
                EmploymentPeriod period = new EmploymentPeriod();
                period.setStartDate(Date.valueOf("2010-11-12"));
                period.setEndDate(Date.valueOf("2010-11-13"));
                employee.setPeriod(period);
                employee.setWorkWeek(new HashSet());
                employee.getWorkWeek().add(Employee.Weekdays.MONDAY);
                employee.getWorkWeek().add(Employee.Weekdays.TUESDAY);
                employee.getWorkWeek().add(Employee.Weekdays.WEDNESDAY);
                employee.getWorkWeek().add(Employee.Weekdays.THURSDAY);
                employee.setStatus(Employee.EmployeeStatus.FULL_TIME);
                employee.setPayScale(Employee.SalaryRate.EXECUTIVE);
                employee.setFormerEmployment(new FormerEmployment("Original", new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1990, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1993, (int)11, (int)31))));
                Vector<Employee> emps = new Vector<Employee>(2);
                Employee emp1 = new Employee();
                emp1.setFirstName("Hemavatinandan");
                emp1.setLastName("Padmabandhu");
                emp1.setManager(employee);
                emps.add(emp1);
                Employee emp2 = new Employee();
                emp2.setFirstName("Deepaprabha");
                emp2.setLastName("Kanchanprabha");
                emp2.setManager(employee);
                emps.add(emp2);
                employee.setManagedEmployees(emps);
                Vector<Object> projs = new Vector<Object>(3);
                SmallProject proj1 = new SmallProject();
                proj1.setName("Persistence Enabled in Cloud");
                projs.add(proj1);
                LargeProject proj2 = new LargeProject();
                proj2.setName("Session Data Affinity Test");
                projs.add(proj2);
                LargeProject proj3 = new LargeProject();
                proj3.setName("Release Exit Criteria Testing");
                proj3.setTeamLeader(employee);
                projs.add(proj3);
                employee.setProjects(projs);
                Vector<PhoneNumber> phones = new Vector<PhoneNumber>(2);
                PhoneNumber phone = new PhoneNumber("work", "613", "1234567");
                phones.add(phone);
                phone.setOwner(employee);
                phone = new PhoneNumber("home", "613", "8888666");
                phones.add(phone);
                phone.setOwner(employee);
                employee.setPhoneNumbers(phones);
                this.getEmployeeService().update(employee);
                Thread.currentThread();
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception e) {
                System.out.println("=====the exceptTimes is " + ++exceptTimes);
                if (exceptTimes == 1) continue;
                SessionBeanHATests.fail((String)e.toString());
            }
        }
    }

    public EmployeeService getEmployeeService() throws Exception {
        if (this.service == null) {
            Properties properties = new Properties();
            String url = System.getProperty("server.url");
            if (url != null) {
                properties.put("java.naming.provider.url", url);
            }
            InitialContext context = new InitialContext(properties);
            try {
                this.service = (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("EmployeeService#org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService"), EmployeeService.class);
            }
            catch (NameNotFoundException notFoundException) {
                throw new Error("Lookup failed.", notFoundException);
            }
        }
        return this.service;
    }

    public void testFindAllMultipleThread() throws Exception {
        boolean finished;
        int i;
        FindAllThread[] helperRunnable = new FindAllThread[10];
        for (int i2 = 0; i2 < helperRunnable.length; ++i2) {
            helperRunnable[i2] = new FindAllThread(i2);
        }
        ServerPlatform platform = JUnitTestCase.getServerSession((String)"sessionbean").getServerPlatform();
        for (i = 0; i < helperRunnable.length; ++i) {
            platform.launchContainerRunnable((Runnable)helperRunnable[i]);
        }
        do {
            Thread.currentThread();
            Thread.sleep(3000L);
            finished = true;
            for (int i3 = 0; i3 < helperRunnable.length; ++i3) {
                finished = finished && helperRunnable[i3].finished;
            }
        } while (!finished);
        for (i = 0; i < helperRunnable.length; ++i) {
            if (helperRunnable[i].succeeded) continue;
            SessionBeanHATests.fail((String)("RAC failure caused some other exception: " + helperRunnable[i].relatedException));
        }
    }

    static {
        jtaCount = 2514;
        nonJTACount = 2514;
    }
}

