/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.nativeapitest;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.nativeapitest.Address;
import org.eclipse.persistence.testing.models.nativeapitest.Department;
import org.eclipse.persistence.testing.models.nativeapitest.Employee;
import org.eclipse.persistence.testing.models.nativeapitest.EmployeeService;
import org.eclipse.persistence.testing.models.nativeapitest.NativeAPITestTableCreator;

public class NativeAPITests
extends JUnitTestCase {
    protected EmployeeService service;
    private static final String[] LOOKUP_STRINGS = new String[]{"java:comp/env/ejb/EmployeeService", "ejb/EmployeeService", "EmployeeService#org.eclipse.persistence.testing.models.nativeapitest.EmployeeService", "org.eclipse.persistence.testing.models.nativeapitest.EmployeeService", "eclipselink-nativeapitest-model/EmployeeServiceBean/remote-org.eclipse.persistence.testing.models.nativeapitest.EmployeeService", "JavaEE/servertest/REMOTE/EmployeeServiceBean/org.eclipse.persistence.testing.models.nativeapitest.EmployeeService"};

    public NativeAPITests() {
    }

    public NativeAPITests(String name) {
        super(name);
    }

    public NativeAPITests(String name, boolean shouldRunTestOnServer) {
        super(name);
        this.shouldRunTestOnServer = shouldRunTestOnServer;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("NativeAPITests");
        suite.addTest((Test)new NativeAPITests("testSetup", true));
        suite.addTest((Test)new NativeAPITests("testFindAll", false));
        suite.addTest((Test)new NativeAPITests("testFindAllServer", true));
        suite.addTest((Test)new NativeAPITests("testMerge", false));
        suite.addTest((Test)new NativeAPITests("testMergeServer", true));
        return suite;
    }

    public void testSetup() throws Exception {
        new NativeAPITestTableCreator().replaceTables((DatabaseSession)((ServerSession)SessionManager.getManager().getSession("NativeAPITest", ((Object)((Object)this)).getClass().getClassLoader())));
        Employee bob = new Employee();
        bob.setFirstName("Bob");
        bob.setLastName("Jones");
        bob.setAddress(new Address());
        bob.setDepartment(new Department());
        this.getEmployeeService().insert(bob);
        Employee joe = new Employee();
        joe.setFirstName("Joe");
        joe.setLastName("Smith");
        joe.setAddress(new Address());
        joe.setDepartment(new Department());
        this.getEmployeeService().insert(joe);
    }

    public EmployeeService getEmployeeService() throws Exception {
        if (this.service != null) {
            return this.service;
        }
        Properties properties = new Properties();
        String url = System.getProperty("server.url");
        if (url != null) {
            properties.put("java.naming.provider.url", url);
        }
        InitialContext context = new InitialContext(properties);
        for (String candidate : LOOKUP_STRINGS) {
            try {
                this.service = (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup(candidate), EmployeeService.class);
                return this.service;
            }
            catch (NamingException namingException) {
            }
        }
        throw new RuntimeException("EmployeeService bean could not be looked up under any of the following names:\n" + Arrays.asList(LOOKUP_STRINGS));
    }

    public void testFindAll() throws Exception {
        List result = this.getEmployeeService().findAll();
        for (Employee employee : result) {
            Address address;
            boolean caughtError;
            block10: {
                block9: {
                    employee.getFirstName();
                    employee.getLastName();
                    caughtError = false;
                    address = null;
                    try {
                        address = employee.getAddress();
                    }
                    catch (ValidationException exception) {
                        caughtError = true;
                        if (exception.getErrorCode() == 7242) break block9;
                        throw exception;
                    }
                }
                if (address == null) {
                    if (NativeAPITests.isOnServer() && !caughtError) {
                        NativeAPITests.fail((String)"INSTANTIATING_VALUEHOLDER_WITH_NULL_SESSION error not thrown.");
                    } else {
                        NativeAPITests.warning((String)"Client serialization nulls non-instantiated 1-1s.");
                    }
                }
                if (employee.getDepartment() == null) {
                    NativeAPITests.fail((String)"Department is null, failed to serialize eager.");
                }
                caughtError = false;
                try {
                    employee.getPhoneNumbers().size();
                }
                catch (ValidationException exception) {
                    caughtError = true;
                    if (exception.getErrorCode() == 7242) break block10;
                    throw exception;
                }
            }
            if (address != null || caughtError) continue;
            NativeAPITests.fail((String)"INSTANTIATING_VALUEHOLDER_WITH_NULL_SESSION error not thrown.");
        }
    }

    public void testFindAllServer() throws Exception {
        this.testFindAll();
    }

    public void testMerge() throws Exception {
        Employee employee = new Employee();
        employee.setFirstName("Bob");
        employee.setLastName("Smith");
        Employee manager = new Employee();
        manager.setFirstName("Jon");
        manager.setLastName("Way");
        employee.setAddress(new Address());
        employee.getAddress().setCity("Nepean");
        employee.setManager(manager);
        int id = this.getEmployeeService().insert(employee);
        employee = this.getEmployeeService().findById(id);
        employee.setLastName("Wayy");
        employee.getAddress().setCity("Kanata");
        this.getEmployeeService().update(employee);
        employee = this.getEmployeeService().findById(id);
        if (!employee.getLastName().equals("Wayy")) {
            NativeAPITests.fail((String)"Last name not updated.");
        }
        if (!employee.getAddress().getCity().equals("Kanata")) {
            NativeAPITests.fail((String)"City not updated.");
        }
        if ((employee = this.getEmployeeService().fetchById(id)).getManager() == null) {
            if (NativeAPITests.isOnServer()) {
                NativeAPITests.fail((String)"Manager merged to null.");
            } else {
                NativeAPITests.warning((String)"Merge from client serialization nulls non-instantiated 1-1s.");
            }
        }
    }

    public void testMergeServer() throws Exception {
        this.testMerge();
    }
}

