/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import java.util.Iterator;
import org.eclipse.persistence.testing.models.aggregate.Aggregate;
import org.eclipse.persistence.testing.models.aggregate.Child;
import org.eclipse.persistence.testing.models.aggregate.Relative;

public class Parent {
    protected int id;
    protected Aggregate aggregate = new Aggregate();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    public void addChild(Child child) {
        if (child != null && !this.getAggregate().getChildren().contains(child)) {
            this.getAggregate().getChildren().add(child);
            child.setParent(this);
        }
    }

    public void removeChild(Child child) {
        if (child != null && this.getAggregate().getChildren().contains(child)) {
            this.getAggregate().getChildren().remove(child);
            child.setParent(null);
        }
    }

    public void addRelative(Relative relative) {
        if (relative != null && !this.getAggregate().getRelatives().contains(relative)) {
            this.getAggregate().getRelatives().add(relative);
        }
    }

    public void removeRelative(Relative relative) {
        if (relative != null && this.getAggregate().getRelatives().contains(relative)) {
            this.getAggregate().getRelatives().remove(relative);
        }
    }

    public void removeAllRelatives() {
        Iterator<Relative> iterator = this.getAggregate().getRelatives().iterator();
        while (iterator.hasNext()) {
            this.removeRelative(iterator.next());
        }
    }
}

