/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.filter;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.BitTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.filter.FilterAdapter;
import org.eclipse.persistence.tools.utility.filter.SimpleFilter;
import org.eclipse.persistence.tools.utility.filter.XORFilter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class XORFilterTests
extends TestCase {
    private XORFilter<Number> xorFilter;

    public XORFilterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.xorFilter = new XORFilter(this.buildMinFilter(1.0), this.buildMaxFilter(10.0));
    }

    private Filter<Number> buildMinFilter(double min) {
        return new MinFilter(min);
    }

    private Filter<Number> buildMaxFilter(double max) {
        return new MaxFilter(max);
    }

    private Filter<Number> buildEvenFilter() {
        return new EvenFilter();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testFiltering2() {
        XORFilterTests.assertFalse((boolean)this.xorFilter.accept((Object)new Integer(7)));
        XORFilterTests.assertFalse((boolean)this.xorFilter.accept((Object)new Integer(2)));
        XORFilterTests.assertFalse((boolean)this.xorFilter.accept((Object)new Double(6.666)));
        XORFilterTests.assertTrue((boolean)this.xorFilter.accept((Object)new Double(-99.0)));
        XORFilterTests.assertTrue((boolean)this.xorFilter.accept((Object)new Double(-1.0)));
        XORFilterTests.assertTrue((boolean)this.xorFilter.accept((Object)new Double(11.0)));
        XORFilterTests.assertTrue((boolean)this.xorFilter.accept((Object)new Double(111.0)));
    }

    public void testFiltering3() {
        XORFilter xorFilter2 = new XORFilter(this.xorFilter, this.buildEvenFilter());
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Integer(7)));
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Integer(3)));
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Integer(9)));
        XORFilterTests.assertTrue((boolean)xorFilter2.accept((Object)new Integer(2)));
        XORFilterTests.assertTrue((boolean)xorFilter2.accept((Object)new Double(6.1)));
        XORFilterTests.assertTrue((boolean)xorFilter2.accept((Object)new Double(-99.0)));
        XORFilterTests.assertTrue((boolean)xorFilter2.accept((Object)new Double(-1.0)));
        XORFilterTests.assertTrue((boolean)xorFilter2.accept((Object)new Double(11.0)));
        XORFilterTests.assertTrue((boolean)xorFilter2.accept((Object)new Double(111.0)));
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Double(-98.0)));
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Double(0.0)));
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Double(-2.0)));
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Double(12.0)));
        XORFilterTests.assertFalse((boolean)xorFilter2.accept((Object)new Double(222.0)));
    }

    public void testClone() {
        XORFilter xorFilter2 = (XORFilter)this.xorFilter.clone();
        XORFilterTests.assertEquals((Object)this.xorFilter.getFilters()[0], (Object)xorFilter2.getFilters()[0]);
        XORFilterTests.assertEquals((Object)this.xorFilter.getFilters()[1], (Object)xorFilter2.getFilters()[1]);
        XORFilterTests.assertNotSame(this.xorFilter, (Object)xorFilter2);
    }

    public void testEquals() {
        XORFilter xorFilter2 = new XORFilter(this.buildMinFilter(1.0), this.buildMaxFilter(10.0));
        XORFilterTests.assertEquals(this.xorFilter, (Object)xorFilter2);
        XORFilterTests.assertEquals((int)this.xorFilter.hashCode(), (int)xorFilter2.hashCode());
    }

    public void testSerialization() throws Exception {
        XORFilter<Number> xorFilter2 = TestTools.serialize(this.xorFilter);
        XORFilterTests.assertEquals((Object)this.xorFilter.getFilters()[0], (Object)xorFilter2.getFilters()[0]);
        XORFilterTests.assertEquals((Object)this.xorFilter.getFilters()[1], (Object)xorFilter2.getFilters()[1]);
        XORFilterTests.assertNotSame(this.xorFilter, xorFilter2);
    }

    static class EvenFilter
    extends FilterAdapter<Number> {
        EvenFilter() {
        }

        public boolean accept(Number number) {
            return BitTools.isEven((int)number.intValue());
        }
    }

    static class MaxFilter
    extends SimpleFilter<Number, Number> {
        private static final long serialVersionUID = 1L;

        MaxFilter(double min) {
            super((Object)new Double(min));
        }

        public boolean accept(Number number) {
            return number.doubleValue() >= ((Number)this.criterion).doubleValue();
        }
    }

    static class MinFilter
    extends SimpleFilter<Number, Number> {
        private static final long serialVersionUID = 1L;

        MinFilter(double min) {
            super((Object)new Double(min));
        }

        public boolean accept(Number number) {
            return number.doubleValue() <= ((Number)this.criterion).doubleValue();
        }
    }
}

