/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.reference;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.reference.IntReference;
import org.eclipse.persistence.tools.utility.reference.SimpleIntReference;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class SimpleIntReferenceTests
extends TestCase {
    public SimpleIntReferenceTests(String name) {
        super(name);
    }

    public void testCtors() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertEquals((int)7, (int)ir.getValue());
        ir = new SimpleIntReference(-7);
        SimpleIntReferenceTests.assertEquals((int)-7, (int)ir.getValue());
    }

    public void testEqualsInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertTrue((boolean)ir.equals(0));
        SimpleIntReferenceTests.assertFalse((boolean)ir.equals(7));
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertTrue((boolean)ir.equals(7));
        SimpleIntReferenceTests.assertFalse((boolean)ir.equals(0));
    }

    public void testNotEqualInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertFalse((boolean)ir.notEqual(0));
        SimpleIntReferenceTests.assertTrue((boolean)ir.notEqual(7));
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertFalse((boolean)ir.notEqual(7));
        SimpleIntReferenceTests.assertTrue((boolean)ir.notEqual(0));
    }

    public void testIsZero() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertTrue((boolean)ir.isZero());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertFalse((boolean)ir.isZero());
    }

    public void testIsNotZero() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertFalse((boolean)ir.isNotZero());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertTrue((boolean)ir.isNotZero());
    }

    public void testIsGreaterThanInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertTrue((boolean)ir.isGreaterThan(-1));
        SimpleIntReferenceTests.assertFalse((boolean)ir.isGreaterThan(0));
        SimpleIntReferenceTests.assertFalse((boolean)ir.isGreaterThan(7));
    }

    public void testIsGreaterThanOrEqualInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertTrue((boolean)ir.isGreaterThanOrEqual(-1));
        SimpleIntReferenceTests.assertTrue((boolean)ir.isGreaterThanOrEqual(0));
        SimpleIntReferenceTests.assertFalse((boolean)ir.isGreaterThanOrEqual(7));
    }

    public void testIsLessThanInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertFalse((boolean)ir.isLessThan(-1));
        SimpleIntReferenceTests.assertFalse((boolean)ir.isLessThan(0));
        SimpleIntReferenceTests.assertTrue((boolean)ir.isLessThan(7));
    }

    public void testIsLessThanOrEqualInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertFalse((boolean)ir.isLessThanOrEqual(-1));
        SimpleIntReferenceTests.assertTrue((boolean)ir.isLessThanOrEqual(0));
        SimpleIntReferenceTests.assertTrue((boolean)ir.isLessThanOrEqual(7));
    }

    public void testIsPositive() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertFalse((boolean)ir.isPositive());
        ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertFalse((boolean)ir.isPositive());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertTrue((boolean)ir.isPositive());
    }

    public void testIsNotPositive() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertTrue((boolean)ir.isNotPositive());
        ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertTrue((boolean)ir.isNotPositive());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertFalse((boolean)ir.isNotPositive());
    }

    public void testIsNegative() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertTrue((boolean)ir.isNegative());
        ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertFalse((boolean)ir.isNegative());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertFalse((boolean)ir.isNegative());
    }

    public void testIsNotNegative() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertFalse((boolean)ir.isNotNegative());
        ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertTrue((boolean)ir.isNotNegative());
        ir = new SimpleIntReference(7);
        SimpleIntReferenceTests.assertTrue((boolean)ir.isNotNegative());
    }

    public void testSetValueInt() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)-3, (int)ir.setValue(4));
        SimpleIntReferenceTests.assertEquals((int)4, (int)ir.getValue());
    }

    public void testAbs() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)3, (int)ir.abs());
        ir.setValue(3);
        SimpleIntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)3, (int)ir.abs());
    }

    public void testNeg() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)3, (int)ir.neg());
        ir.setValue(3);
        SimpleIntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)-3, (int)ir.neg());
    }

    public void testSetZero() {
        SimpleIntReference ir = new SimpleIntReference(-3);
        SimpleIntReferenceTests.assertEquals((int)-3, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)-3, (int)ir.setZero());
        SimpleIntReferenceTests.assertEquals((int)0, (int)ir.getValue());
    }

    public void testAddInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int value = ir.add(3);
        SimpleIntReferenceTests.assertEquals((int)3, (int)value);
        ir.setValue(3);
        value = ir.add(-7);
        SimpleIntReferenceTests.assertEquals((int)-4, (int)value);
    }

    public void testIncrement() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int value = ir.increment();
        SimpleIntReferenceTests.assertEquals((int)1, (int)value);
        SimpleIntReferenceTests.assertEquals((int)1, (int)ir.getValue());
    }

    public void testSubtractInt() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int count = ir.subtract(3);
        SimpleIntReferenceTests.assertEquals((int)-3, (int)count);
        ir.setValue(-3);
        count = ir.subtract(-7);
        SimpleIntReferenceTests.assertEquals((int)4, (int)count);
    }

    public void testDecrement() {
        SimpleIntReference ir = new SimpleIntReference();
        SimpleIntReferenceTests.assertEquals((int)0, (int)ir.getValue());
        int count = ir.decrement();
        SimpleIntReferenceTests.assertEquals((int)-1, (int)count);
        SimpleIntReferenceTests.assertEquals((int)-1, (int)ir.getValue());
    }

    public void testMultiplyInt() {
        SimpleIntReference ir = new SimpleIntReference(3);
        SimpleIntReferenceTests.assertEquals((int)3, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)9, (int)ir.multiply(3));
    }

    public void testDivideInt() {
        SimpleIntReference ir = new SimpleIntReference(24);
        SimpleIntReferenceTests.assertEquals((int)24, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)8, (int)ir.divide(3));
    }

    public void testRemainderInt() {
        SimpleIntReference ir = new SimpleIntReference(25);
        SimpleIntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)1, (int)ir.remainder(3));
    }

    public void testMinInt() {
        SimpleIntReference ir = new SimpleIntReference(25);
        SimpleIntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)3, (int)ir.min(3));
        SimpleIntReferenceTests.assertEquals((int)25, (int)ir.min(33));
    }

    public void testMaxInt() {
        SimpleIntReference ir = new SimpleIntReference(25);
        SimpleIntReferenceTests.assertEquals((int)25, (int)ir.getValue());
        SimpleIntReferenceTests.assertEquals((int)25, (int)ir.max(3));
        SimpleIntReferenceTests.assertEquals((int)30, (int)ir.max(30));
    }

    public void testPowInt() {
        SimpleIntReference ir = new SimpleIntReference(5);
        SimpleIntReferenceTests.assertEquals((int)5, (int)ir.getValue());
        SimpleIntReferenceTests.assertTrue((ir.pow(2) == 25.0 ? 1 : 0) != 0);
    }

    public void testCompareToIntReference() {
        SimpleIntReference ir1 = new SimpleIntReference(44);
        SimpleIntReference ir2 = new SimpleIntReference(44);
        SimpleIntReferenceTests.assertTrue((ir1.compareTo((IntReference)ir2) == 0 ? 1 : 0) != 0);
        ir2 = new SimpleIntReference(55);
        SimpleIntReferenceTests.assertTrue((ir1.compareTo((IntReference)ir2) < 0 ? 1 : 0) != 0);
        ir2 = new SimpleIntReference(33);
        SimpleIntReferenceTests.assertTrue((ir1.compareTo((IntReference)ir2) > 0 ? 1 : 0) != 0);
    }

    public void testClone() {
        SimpleIntReference ir1 = new SimpleIntReference(44);
        SimpleIntReference ir2 = ir1.clone();
        SimpleIntReferenceTests.assertEquals((int)44, (int)ir2.getValue());
        SimpleIntReferenceTests.assertNotSame((Object)ir1, (Object)ir2);
    }

    public void testSerialization() throws Exception {
        SimpleIntReference ir1 = new SimpleIntReference(44);
        SimpleIntReference ir2 = TestTools.serialize(ir1);
        SimpleIntReferenceTests.assertEquals((int)44, (int)ir2.getValue());
        SimpleIntReferenceTests.assertNotSame((Object)ir1, (Object)ir2);
    }

    public void testToString() {
        SimpleIntReference ir = new SimpleIntReference(5);
        SimpleIntReferenceTests.assertEquals((String)"[5]", (String)ir.toString());
    }
}

