/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.model.spi.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.tools.db.model.spi.ExternalDatabase;
import org.eclipse.persistence.tools.db.model.spi.ExternalTableDescription;
import org.eclipse.persistence.tools.db.model.spi.jdbc.JDBCExternalTableDescription;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.ResultSetIterator;

final class JDBCExternalDatabase
implements ExternalDatabase {
    private final Connection connection;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    JDBCExternalDatabase(Connection connection) {
        this.connection = connection;
    }

    @Override
    public String[] getCatalogNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getCatalogs();
        }
        catch (SQLException sQLException) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    @Override
    public String[] getSchemaNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getSchemas();
        }
        catch (SQLException sQLException) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    @Override
    public String[] getTableTypeNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getTableTypes();
        }
        catch (SQLException sQLException) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    @Override
    public ExternalTableDescription[] getTableDescriptions(String catalogName, String schemaNamePattern, String tableNamePattern, String[] tableTypeNames) {
        ResultSet resultSet;
        if (catalogName != null) {
            try {
                this.getConnection().setCatalog(catalogName);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            resultSet = this.metaData().getTables(catalogName, schemaNamePattern, tableNamePattern, tableTypeNames);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList tableDescriptions = ListTools.list((Iterator)new ResultSetIterator(resultSet, (ResultSetIterator.Adapter)new ExternalTableDescriptionResultSetAdapter()));
        return tableDescriptions.toArray(new ExternalTableDescription[tableDescriptions.size()]);
    }

    @Override
    public ExternalTableDescription[] getTableDescriptions() {
        return this.getTableDescriptions(null, null, "%", null);
    }

    private Connection getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("not connected");
        }
        return this.connection;
    }

    DatabaseMetaData metaData() {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }

    private String[] buildStringArray(ResultSet resultSet) {
        ArrayList strings = ListTools.list((Iterator)new ResultSetIterator(resultSet, (ResultSetIterator.Adapter)new StringResultSetAdapter()));
        return strings.toArray(new String[strings.size()]);
    }

    private class ExternalTableDescriptionResultSetAdapter
    implements ResultSetIterator.Adapter<ExternalTableDescription> {
        private ExternalTableDescriptionResultSetAdapter() {
        }

        public ExternalTableDescription buildNext(ResultSet rs) throws SQLException {
            return new JDBCExternalTableDescription(rs, JDBCExternalDatabase.this);
        }
    }

    private static class StringResultSetAdapter
    implements ResultSetIterator.Adapter<String> {
        private StringResultSetAdapter() {
        }

        public String buildNext(ResultSet rs) throws SQLException {
            String string = rs.getString(1);
            return string == null ? null : string.trim();
        }
    }
}

