/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * A composite output stream forwards the data written to it
 * to multiple streams.
 */
public class CompositeOutputStream
	extends OutputStream
{
	private OutputStream[] streams;


	/**
	 * Construct a "tee" output stream that writes to the
	 * specified streams.
	 */
	public CompositeOutputStream(OutputStream... streams) {
		super();
		if (streams == null) {
			throw new NullPointerException();
		}
		this.streams = streams;
	}

	@Override
	public synchronized void write(int i) throws IOException {
		for (OutputStream stream : this.streams) {
			stream.write(i);
		}
	}

	@Override
	public synchronized void write(byte[] bytes) throws IOException {
		for (OutputStream stream : this.streams) {
			stream.write(bytes);
		}
	}

	@Override
	public synchronized void write(byte[] bytes, int off, int len) throws IOException {
		for (OutputStream stream : this.streams) {
			stream.write(bytes, off, len);
		}
	}

	@Override
	public synchronized void flush() throws IOException {
		for (OutputStream stream : this.streams) {
			stream.flush();
		}
	}

	@Override
	public synchronized void close() throws IOException {
		for (OutputStream stream : this.streams) {
			stream.close();
		}
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, Arrays.toString(this.streams));
	}
}