/*******************************************************************************
 * Copyright (c) 2008, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.filter;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

@SuppressWarnings("nls")
public class FilterTests extends TestCase {

	public FilterTests(String name) {
		super(name);
	}

	public void testNullFilter() {
		Filter<String> filter = Filter.Transparent.instance();
		assertTrue(filter.accept(""));
		assertTrue(filter.accept("foo"));
		assertTrue(filter.accept("bar"));
	}

	public void testNullFilter_toString() {
		Filter<String> filter = Filter.Transparent.instance();
		assertNotNull(filter.toString());
	}

	public void testNullFilter_serialization() throws Exception {
		Filter<String> filter = Filter.Transparent.instance();
		assertSame(filter, TestTools.serialize(filter));
	}

	public void testOpaqueFilter() {
		Filter<String> filter = Filter.Opaque.instance();
		assertFalse(filter.accept(""));
		assertFalse(filter.accept("foo"));
		assertFalse(filter.accept("bar"));
	}

	public void testOpaqueFilter_toString() {
		Filter<String> filter = Filter.Opaque.instance();
		assertNotNull(filter.toString());
	}

	public void testOpaqueFilter_serialization() throws Exception {
		Filter<String> filter = Filter.Opaque.instance();
		assertSame(filter, TestTools.serialize(filter));
	}

	public void testDisabledFilter() {
		Filter<String> filter = Filter.Disabled.instance();
		boolean exCaught = false;
		try {
			assertFalse(filter.accept("foo"));
			fail();
		} catch (UnsupportedOperationException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testDisabledFilter_toString() {
		Filter<String> filter = Filter.Disabled.instance();
		assertNotNull(filter.toString());
	}

	public void testDisabledFilter_serialization() throws Exception {
		Filter<String> filter = Filter.Disabled.instance();
		assertSame(filter, TestTools.serialize(filter));
	}
}