/*******************************************************************************
 * Copyright (c) 2007, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.internal;

import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 *
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 */
public interface OverwriteConfirmer {

	/**
	 * Returns whether the entity generator should overwrite the specified file.
	 */
	boolean overwrite(String className);

	final class Always implements OverwriteConfirmer {

		public static final OverwriteConfirmer INSTANCE = new Always();

		public static OverwriteConfirmer instance() {
			return INSTANCE;
		}

		// ensure single instance
		private Always() {
			super();
		}

		// everything will be overwritten
		@Override
		public boolean overwrite(String className) {
			return true;
		}

		@Override
		public String toString() {
			return ObjectTools.toString(this);
		}
	}

	final class Never implements OverwriteConfirmer {

		public static final OverwriteConfirmer INSTANCE = new Never();

		public static OverwriteConfirmer instance() {
			return INSTANCE;
		}

		// ensure single instance
		private Never() {
			super();
		}

		// nothing will be overwritten
		@Override
		public boolean overwrite(String className) {
			return false;
		}

		@Override
		public String toString() {
			return ObjectTools.toString(this);
		}
	}
}