/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface represents the basis for all basic map mapping types defined by the EclipseLink
 * JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalBasicMapMapping extends ExternalBasicCollectionMapping {

	/**
	 * Adds the key column for this mapping.
	 */
	void addKeyColumn(String columnName);

	/**
	 * Adds the key converter string to the mapping.
	 */
	void addKeyConverterString(String converter);

	/**
	 * Returns the key column for this mapping.
	 */
	ExternalEntityColumn getKeyColumn();

	/**
	 * Returns the key converter for this mapping.
	 */
	ExternalConverter getKeyConverter();

	/**
	 * Returns the key converter string.
	 */
	String getKeyConveter();

	/**
	 * Returns the key object type converter for this mapping.
	 */
	ExternalObjectTypeConverter getKeyObjectTypeConverter();

	/**
	 * Returns the key struct converter for this mapping.
	 */
	ExternalStructConverter getKeyStructConverter();

	/**
	 * Returns the key type converter for this mapping.
	 */
	ExternalTypeConverter getKeyTypeConverter();

	/**
	 * Removes the key column from this mapping.
	 */
	void removeKeyColumn();

	/**
	 * Removes the key converter from mapping.
	 */
	void removeKeyConverter();

	/**
	 * Removes the key converter String.
	 */
	void removeKeyConverterString();

	/**
	 * Removes the key object type converter from mapping.
	 */
	void removeKeyObjectTypeConverter();

	/**
	 * Removes the key struct converter from mapping.
	 */
	void removeKeyStructConverter();

	/**
	 * Removes the key type converter from mapping.
	 */
	void removeKeyTypeConverter();

	/**
	 * Sets the mapping to use this converter for its key converter.
	 */
	void setAsKeyConverter(String name, String className);

	/**
	 * Sets the mapping to use this object type converter for its key converter.
	 */
	void setAsKeyObjectTypeConverter(String name);

	/**
	 * Sets the mapping to use this struct converter for its key converter.
	 */
	void setAsKeyStructConverter(String name, String converter);

	/**
	 * Sets the mapping to use this type converter for its key converter.
	 */
	void setAsKeyTypeConverter(String name);

	/**
	 * Sets the key converter string value.
	 */
	void setKeyConverter(String value);
}