/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.CascadeType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * Captures the common properties associated with all relationship mappings defined by the JPA
 * specification.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalRelationshipMapping extends ExternalMappedMapping {

	/**
	 * Adds a batch fetch to use.
	 */
	void addBatchFetch();

	/**
	 * Adds a cascaded type to use.
	 */
	void addCascadeType(CascadeType type);

	/**
	 * Creates new join table for this relationship mapping replacing the old one.
	 */
	ExternalJoinTable addJoinTable();

	/**
	 * Returns the enum, CascadeType to use for this relationship.
	 */
	ListIterable<CascadeType> cascadeTypes();

	/**
	 * Returns the batch fetch definition for this relationship mapping.
	 */
	ExternalBatchFetch getBatchFetch();

	/**
	 * Returns the join fetch type for this mapping.
	 */
	JoinFetchType getJoinFetchType();

	/**
	 * Returns the join table definition for this relationship mapping.
	 */
	ExternalJoinTable getJoinTable();

	/**
	 * Returns the relationship partner name for this mapping.
	 */
	String getTargetEntityName();

	/**
	 * Removes the batch fetch.
	 */
	void removeBatchFetch();

	/**
	 * Removes a cascade type.
	 */
	void removeCascadeType(CascadeType type);

	/**
	 * Removes the join table from this mapping.
	 */
	void removeJoinTable();

	/**
	 * Sets a join fetch type to this mapping.
	 */
	void setJoinFetchType(JoinFetchType type);

	/**
	 * Sets the relationship partner name.
	 */
	void setTargetEntityName(String entityName);
}