/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * Defines the properties of a Table Generator defined in the ORM.xml. A Table Generator may be
 * owned the root of the ORM xml (entity-mappings), an Entity or an Entity's ID definition.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author Les Davis
 * @author John Bracken
 */
public interface ExternalTableGenerator extends ExternalPrimaryKeyGenerator {

	/**
	 * Adds a unique constraint with the given column names to this table generator.
	 */
	void addUniqueConstraint(int index, ListIterator<String> columnNames);

	/**
	 * Returns the name of the Primary Key column for the generated table.
	 */
	String getPKColumnName();

	/**
	 * Returns the value for the primary key column.
	 */
	String getPKColumnValue();

	/**
	 * Returns the name of the table that will be generated.
	 */
	String getTableName();

	/**
	 * Returns a unique constraint that has been defined at the given position.
	 */
	ExternalUniqueConstraint getUniqueConstraint(int index);

	/**
	 * Returns the value column name.
	 */
	String getValueColumnName();

	/**
	 * Removes a unique constraint from this table generator at the specified position.
	 */
	void removeUniqueConstraint(int index);

	/**
	 * Set the PK column name.
	 */
	void setPKColumnName(String name);

	/**
	 * Set the PK column value.
	 */
	void setPKColumnValue(String value);

	/**
	 * Set the table name.
	 */
	void setTableName(String name);

	/**
	 * Set the value column name.
	 */
	void setValueColumnName(String name);

	/**
	 * List of all unique constraints known to this table generator.
	 */
	ListIterable<ExternalUniqueConstraint> uniqueConstraints();

	/**
	 * The count of all unique constraints known to this table generator.
	 */
	int uniqueConstraintsSize();
}