/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;

public final class SessionCellRendererAdapter
extends AbstractCellRendererAdapter {
    private final String prefixKey;
    private final ResourceRepository repository;

    public SessionCellRendererAdapter(ResourceRepository repository) {
        this(repository, "PROJECT_SESSIONS_SESSION_TYPE");
    }

    public SessionCellRendererAdapter(ResourceRepository repository, String prefixKey) {
        this.repository = repository;
        this.prefixKey = prefixKey;
    }

    private static String buildKey(SessionAdapter session, String prefixKey) {
        StringBuffer sb = new StringBuffer(prefixKey);
        if (session instanceof ServerSessionAdapter) {
            sb.append("_SERVER");
        } else if (session instanceof DatabaseSessionAdapter) {
            sb.append("_DATABASE");
        } else if (session instanceof SessionBrokerAdapter) {
            sb.append("_BROKER");
        }
        if (session.platformIsXml()) {
            sb.append("_XML");
        } else if (session.platformIsRdbms()) {
            sb.append("_RDBMS");
        } else if (session.platformIsEis()) {
            sb.append("_EIS");
        }
        return sb.toString();
    }

    public static String iconKey(SessionAdapter session) {
        return SessionCellRendererAdapter.buildKey(session, "SESSION");
    }

    @Override
    public String buildAccessibleName(Object value) {
        SessionAdapter session = (SessionAdapter)value;
        String bundleKey = SessionCellRendererAdapter.buildKey(session, "SESSION_DISPLAY_STRING_TITLE_BAR");
        return this.repository.getString(bundleKey, session.displayString(), session.getDataSourceName());
    }

    @Override
    public Icon buildIcon(Object value) {
        SessionAdapter session = (SessionAdapter)value;
        return this.repository.getIcon(SessionCellRendererAdapter.iconKey(session));
    }

    @Override
    public String buildText(Object value) {
        SessionAdapter session = (SessionAdapter)value;
        String bundleKey = SessionCellRendererAdapter.buildKey(session, this.prefixKey);
        return this.repository.getString(bundleKey, session.displayString(), session.getDataSourceName());
    }
}

