/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLExceptionTest;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class IdentifierTest
extends JPQLTestCase {
    public static IdentifierTest underscoreIdentTest() {
        IdentifierTest theTest = new IdentifierTest();
        theTest.setName("Underscore identifier test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM Employee emp");
        return theTest;
    }

    public static IdentifierTest dollarSignIdentTest() {
        IdentifierTest theTest = new IdentifierTest();
        theTest.setName("Dollar sign identifier test");
        theTest.setEjbqlString("SELECT OBJECT($emp) FROM Employee $emp");
        return theTest;
    }

    public static IdentifierTest underscoreSchemaNameTest() {
        IdentifierTest theTest = new IdentifierTest();
        theTest.setName("Underscore Schema name test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM _Employee emp");
        return theTest;
    }

    public static IdentifierTest dollarSignSchemaNameTest() {
        IdentifierTest theTest = new IdentifierTest();
        theTest.setName("Dollar sign Schema name test");
        theTest.setEjbqlString("SELECT OBJECT(emp) FROM $Employee emp");
        return theTest;
    }

    public static IdentifierTest numericIdentTest() {
        IdentifierTest theTest = new IdentifierTest();
        theTest.setName("Numeric Identifier test");
        theTest.setEjbqlString("SELECT OBJECT(emp1) FROM Employee emp1");
        return theTest;
    }

    public static JPQLExceptionTest badIdentifierTest1() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.setName("Bad Identifier test1");
        theTest.setEjbqlString("SELECT OBJECT(+emp1) FROM Employee +emp1");
        theTest.expectedException = JPQLException.syntaxErrorAt(null, (int)0, (int)0, null, null);
        return theTest;
    }

    public static JPQLExceptionTest badIdentifierTest2() {
        JPQLExceptionTest theTest = new JPQLExceptionTest();
        theTest.setName("Bad Identifier test2");
        theTest.setEjbqlString("SELECT OBJECT(emp 1) FROM Employee emp 1");
        theTest.expectedException = JPQLException.syntaxErrorAt(null, (int)0, (int)0, null, null);
        return theTest;
    }

    public static IdentifierTest complexIdentTest() {
        IdentifierTest theTest = new IdentifierTest();
        theTest.setName("Complex Identifier test");
        theTest.setEjbqlString("SELECT OBJECT(_$emp1) FROM Employee _$emp1");
        return theTest;
    }

    public static void addTestsTo(TestSuite theSuite) {
        TestSuite newSuite = new TestSuite();
        newSuite.setName("Identifier test suite");
        newSuite.addTest((Test)IdentifierTest.complexIdentTest());
        newSuite.addTest((Test)IdentifierTest.dollarSignIdentTest());
        newSuite.addTest((Test)IdentifierTest.dollarSignSchemaNameTest());
        newSuite.addTest((Test)IdentifierTest.numericIdentTest());
        newSuite.addTest((Test)IdentifierTest.underscoreIdentTest());
        newSuite.addTest((Test)IdentifierTest.underscoreSchemaNameTest());
        theSuite.addTest((Test)newSuite);
    }

    @Override
    public void setup() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        this.setOriginalOject(employees);
        super.setup();
    }
}

