/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.testing.tests.types.WriteTypeObjectTest;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class CLOBTester
extends TypeTester {
    public String longString;
    protected int length;

    public CLOBTester() {
        this(0);
    }

    public CLOBTester(int numChars) {
        super("CLOB(" + numChars + ")");
        this.length = numChars;
        this.longString = null;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(CLOBTester.class);
        descriptor.setTableName("CLOBS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("longString", "THECLOB");
        return descriptor;
    }

    public static RelationalDescriptor descriptorWithAccessors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(CLOBTester.class);
        descriptor.setTableName("CLOBS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("longString", "getLongString", "setLongString", "THECLOB");
        return descriptor;
    }

    public boolean equals(CLOBTester otherTester, Session session) throws TestWarningException {
        if (!this.getTestName().equals(otherTester.getTestName())) {
            return false;
        }
        if (!(this.getLongString().equals(otherTester.getLongString()) || this.getLongString().length() == 0 && otherTester.getLongString() == null)) {
            return false;
        }
        if (otherTester.getLongString() == null) {
            throw new TestWarningException("Empty columns can be returned as NULL.");
        }
        return true;
    }

    public String getLongString() {
        return this.longString;
    }

    public void setLongString(String newString) {
        this.longString = newString;
    }

    @Override
    public void setup(Session session) {
        if (session.getPlatform().isAccess()) {
            throw new TestWarningException("Access does not support BLOBS or CLOBS.");
        }
        if (this.longString == null) {
            String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`1234567890-=\\~!@#$%^&*()_+|[]{};':\",./<>?";
            if (session.getPlatform().isMySQL()) {
                chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`1234567890-=~!@#$%^&*()_+|[]{};':\",./<>?";
            }
            StringWriter writer = new StringWriter();
            int index = 0;
            int charIndex = 0;
            while (index < this.length) {
                if (charIndex == chars.length()) {
                    charIndex = 0;
                }
                writer.write(chars.charAt(charIndex));
                ++index;
                ++charIndex;
            }
            this.longString = writer.toString();
        }
    }

    public static TableDefinition tableDefinition(Session session) {
        TableDefinition definition = TypeTester.tableDefinition();
        definition.setName("CLOBS");
        definition.addField("THECLOB", Character[].class, 25000);
        return definition;
    }

    public static Vector testInstances() {
        Vector<CLOBTester> tests = new Vector<CLOBTester>();
        tests.addElement(new CLOBTester(1000));
        tests.addElement(new CLOBTester(5000));
        tests.addElement(new CLOBTester(10000));
        tests.addElement(new CLOBTester(25000));
        return tests;
    }

    public String toString() {
        return this.getTestName();
    }

    @Override
    protected void verify(WriteTypeObjectTest testCase) throws TestErrorException, TestWarningException {
        try {
            super.verify(testCase);
        }
        catch (TestErrorException verifyFailedException) {
            if (this.caughtException != null && testCase.getSession().getPlatform().isOracle() && ((SQLException)((DatabaseException)((Object)this.caughtException)).getInternalException()).getErrorCode() == 1704) {
                throw new TestWarningException("CLOB Write failed. " + this.caughtException.toString() + "\n Turn on String Binding and re-run test");
            }
            if (testCase.getObjectFromDatabase() == null) {
                throw new TestWarningException("CLOB Write failed.  Object returned as null");
            }
            if (this.equals((CLOBTester)testCase.getObjectFromDatabase(), testCase.getSession())) {
                return;
            }
            throw verifyFailedException;
        }
    }
}

