/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalStoredProcedureParameter;
import org.eclipse.persistence.tools.mapping.orm.ExternalStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.Query;
import org.eclipse.persistence.tools.mapping.orm.dom.StoredProcedureParameter;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class NamedStoredProcedureQuery
extends Query
implements ExternalStoredProcedureQuery {
    static final String NAMED_STORED_PROCEDURE_QUERY = "named-stored-procedure-query";
    static final String PROCEDURE_NAME = "procedure-name";
    static final String RESULT_CLASS = "result-class";
    static final String RESULT_SET_MAPPING = "result-set-mapping";
    static final String RETURNS_RESULT_SET = "returns-result-set";

    NamedStoredProcedureQuery(Entity parent, int index) {
        super(parent, index);
    }

    NamedStoredProcedureQuery(ORMConfiguration parent, int index) {
        super(parent, index);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(RESULT_CLASS);
        names.add(RESULT_SET_MAPPING);
        names.add(PROCEDURE_NAME);
        names.add(RETURNS_RESULT_SET);
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        return names;
    }

    @Override
    public ExternalStoredProcedureParameter addParameter(int index) {
        StoredProcedureParameter parameter = this.buildParameter(index);
        parameter.addSelf();
        return parameter;
    }

    private StoredProcedureParameter buildParameter(int index) {
        return new StoredProcedureParameter(this, index);
    }

    @Override
    public Boolean doesReturnResultSet() {
        return this.getBooleanAttribute(RETURNS_RESULT_SET);
    }

    @Override
    protected String getElementName() {
        return NAMED_STORED_PROCEDURE_QUERY;
    }

    @Override
    public ExternalStoredProcedureParameter getParameter(int index) {
        Element element = this.getChild("parameter", index);
        if (element == null) {
            return null;
        }
        return this.buildParameter(index);
    }

    @Override
    public String getProcedureName() {
        return this.getAttribute(PROCEDURE_NAME);
    }

    @Override
    public String getResultClassName() {
        return this.getAttribute(RESULT_CLASS);
    }

    @Override
    public String getResultSetMapping() {
        return this.getAttribute(RESULT_SET_MAPPING);
    }

    @Override
    public ListIterable<ExternalStoredProcedureParameter> parameters() {
        int count = this.parametersSize();
        ArrayList<StoredProcedureParameter> parameters = new ArrayList<StoredProcedureParameter>(count);
        int index = count;
        while (--index >= 0) {
            StoredProcedureParameter queryHint = this.buildParameter(index);
            parameters.add(0, queryHint);
        }
        return new ListListIterable(parameters);
    }

    @Override
    public int parametersSize() {
        return this.getChildrenSize("parameter");
    }

    @Override
    public void removeParameter(int index) {
        StoredProcedureParameter parameter = this.buildParameter(index);
        parameter.removeSelf();
    }

    @Override
    public void setDoesReturnResultSet(Boolean returnResultSet) {
        this.setAttribute(RETURNS_RESULT_SET, returnResultSet);
    }

    @Override
    public void setProcedureName(String name) {
        this.setAttribute(PROCEDURE_NAME, name);
    }

    @Override
    public void setResultClassName(String name) {
        this.setAttribute(RESULT_CLASS, name);
    }

    @Override
    public void setResultSetMapping(String mappingName) {
        this.setAttribute(RESULT_SET_MAPPING, mappingName);
    }
}

