/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.platformsmodel;

import org.eclipse.persistence.tools.db.relational.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.node.AbstractNode;
import org.w3c.dom.Node;

public final class JavaTypeDeclaration
extends AbstractNode {
    private String javaClassName;
    private int arrayDepth;

    JavaTypeDeclaration(AbstractNode parent, Node node) throws CorruptXMLException {
        super((org.eclipse.persistence.tools.utility.node.Node)parent);
        this.read(node);
    }

    JavaTypeDeclaration(AbstractNode parent, String javaClassName, int arrayDepth) {
        super((org.eclipse.persistence.tools.utility.node.Node)parent);
        this.javaClassName = javaClassName;
        this.arrayDepth = arrayDepth;
        this.checkState();
    }

    JavaTypeDeclaration(AbstractNode parent, String javaClassName) {
        this(parent, javaClassName, 0);
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    boolean equals(String otherJavaClassName, int otherArrayDepth) {
        return this.javaClassName.equals(otherJavaClassName) && this.arrayDepth == otherArrayDepth;
    }

    boolean equals(JavaTypeDeclaration other) {
        return this.equals(other.javaClassName, other.arrayDepth);
    }

    private void checkState() {
        if (this.javaClassName == null || this.javaClassName.length() == 0) {
            throw new IllegalStateException("Java class name is required");
        }
        if (this.arrayDepth < 0) {
            throw new IllegalStateException("array depth must be greater than or equal to zero: " + this.arrayDepth);
        }
        if (this.javaClassName.equals(Void.TYPE.getName()) && this.arrayDepth != 0) {
            throw new IllegalStateException("'void' must have an array depth of zero: " + this.arrayDepth);
        }
    }

    private void read(Node node) throws CorruptXMLException {
        if (node == null) {
            throw new CorruptXMLException("missing node");
        }
        this.javaClassName = XMLTools.getChildTextContent((Node)node, (String)"java-class-name", null);
        this.arrayDepth = XMLTools.childIntContent((Node)node, (String)"array-depth", (int)0);
        try {
            this.checkState();
        }
        catch (IllegalStateException ex) {
            throw new CorruptXMLException("illegal state: " + (Object)((Object)this), ex);
        }
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode((Node)node, (String)"java-class-name", (String)this.javaClassName);
        XMLTools.addSimpleTextNode((Node)node, (String)"array-depth", (int)this.arrayDepth, (int)0);
    }

    public String displayString() {
        StringBuffer sb = new StringBuffer();
        this.displayStringOn(sb);
        return sb.toString();
    }

    public void displayStringOn(StringBuffer sb) {
        sb.append(this.javaClassName);
        int i = this.arrayDepth;
        while (i-- > 0) {
            sb.append("[]");
        }
    }

    public void toString(StringBuffer sb) {
        this.displayStringOn(sb);
    }
}

