/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.value.ItemCollectionListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SortedListValueModelWrapper;
import org.eclipse.persistence.tools.utility.tests.TestTools;
import org.eclipse.persistence.tools.utility.tests.model.Displayable;
import org.eclipse.persistence.tools.utility.tests.model.value.CoordinatedList;

public class ItemCollectionListValueModelAdapterTests
extends TestCase {
    private Junk foo;
    private Junk bar;
    private Junk baz;
    private Junk joo;
    private Junk jar;
    private Junk jaz;
    private Junk tom;
    private Junk dick;
    private Junk harry;

    public ItemCollectionListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.foo = new Junk("foo");
        this.bar = new Junk("bar");
        this.baz = new Junk("baz");
        this.joo = new Junk("joo");
        this.jar = new Junk("jar");
        this.jaz = new Junk("jaz");
        this.tom = new Junk("tom");
        this.dick = new Junk("dick");
        this.harry = new Junk("harry");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testCollectionSynchronization() {
        SimpleCollectionValueModel<Junk> collectionHolder = this.buildCollectionHolder();
        ItemCollectionListValueModelAdapter listValueModel = new ItemCollectionListValueModelAdapter(collectionHolder, new String[]{"stuff"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemCollectionListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.add((Object)this.tom);
        collectionHolder.add((Object)this.dick);
        collectionHolder.add((Object)this.harry);
        ItemCollectionListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.remove((Object)this.foo);
        collectionHolder.remove((Object)this.jar);
        collectionHolder.remove((Object)this.harry);
        ItemCollectionListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    public void testListSynchronization() {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemCollectionListValueModelAdapter listValueModel = new ItemCollectionListValueModelAdapter(listHolder, new String[]{"stuff"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemCollectionListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.add(6, (Object)this.tom);
        listHolder.add(7, (Object)this.dick);
        listHolder.add(8, (Object)this.harry);
        ItemCollectionListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.remove(8);
        listHolder.remove(0);
        listHolder.remove(4);
        ItemCollectionListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    private void compare(ListValueModel<Junk> listValueModel, List<Junk> list) {
        ItemCollectionListValueModelAdapterTests.assertEquals((int)listValueModel.size(), (int)list.size());
        int i = 0;
        while (i < listValueModel.size()) {
            ItemCollectionListValueModelAdapterTests.assertEquals((Object)listValueModel.get(i), (Object)list.get(i));
            ++i;
        }
    }

    public void testHasListeners() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyListChangeListeners("stuff"));
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyListChangeListeners("stuff"));
        ItemCollectionListValueModelAdapter listValueModel = new ItemCollectionListValueModelAdapter(listHolder, new String[]{"stuff"});
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyCollectionChangeListeners("stuff"));
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyCollectionChangeListeners("stuff"));
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        ItemCollectionListValueModelAdapterTests.assertTrue((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemCollectionListValueModelAdapterTests.assertTrue((boolean)this.foo.hasAnyCollectionChangeListeners("stuff"));
        ItemCollectionListValueModelAdapterTests.assertTrue((boolean)this.jaz.hasAnyCollectionChangeListeners("stuff"));
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        listValueModel.removeListChangeListener("list values", synchList);
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyCollectionChangeListeners("stuff"));
        ItemCollectionListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyCollectionChangeListeners("stuff"));
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
    }

    public void testGetSize() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemCollectionListValueModelAdapter listValueModel = new ItemCollectionListValueModelAdapter(listHolder, new String[]{"stuff"});
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemCollectionListValueModelAdapterTests.assertEquals((int)6, (int)listValueModel.size());
        ItemCollectionListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
    }

    public void testGet() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        SortedListValueModelWrapper listValueModel = new SortedListValueModelWrapper((ListValueModel)new ItemCollectionListValueModelAdapter(listHolder, new String[]{"stuff"}));
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemCollectionListValueModelAdapterTests.assertEquals((Object)this.bar, (Object)listValueModel.get(0));
        ItemCollectionListValueModelAdapterTests.assertEquals((Object)this.bar, synchList.get(0));
        this.bar.removeStuff("bar");
        this.bar.addStuff("zzz");
        this.bar.addStuff("bar");
        ItemCollectionListValueModelAdapterTests.assertEquals((Object)this.bar, (Object)listValueModel.get(5));
        ItemCollectionListValueModelAdapterTests.assertEquals((Object)this.bar, synchList.get(5));
        this.bar.removeStuff("zzz");
    }

    private void verifyHasNoListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemCollectionListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasNoListChangeListeners("list values"));
    }

    private void verifyHasListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemCollectionListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasAnyListChangeListeners("list values"));
    }

    private SimpleCollectionValueModel<Junk> buildCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildCollection());
    }

    private Collection<Junk> buildCollection() {
        HashBag bag = new HashBag();
        this.populateCollection((Collection<Junk>)bag);
        return bag;
    }

    private SimpleListValueModel<Junk> buildListHolder() {
        return new SimpleListValueModel(this.buildList());
    }

    private List<Junk> buildList() {
        ArrayList<Junk> list = new ArrayList<Junk>();
        this.populateCollection(list);
        return list;
    }

    private void populateCollection(Collection<Junk> c) {
        c.add(this.foo);
        c.add(this.bar);
        c.add(this.baz);
        c.add(this.joo);
        c.add(this.jar);
        c.add(this.jaz);
    }

    private class Junk
    extends AbstractModel
    implements Displayable,
    Comparable<Junk> {
        private Collection<String> stuff = new ArrayList<String>();
        public static final String STUFF_COLLECTION = "stuff";

        public Junk(String stuffItem) {
            this.stuff.add(stuffItem);
        }

        public void addStuff(String stuffItem) {
            this.addItemToCollection(stuffItem, this.stuff, STUFF_COLLECTION);
        }

        public void removeStuff(String stuffItem) {
            this.removeItemFromCollection(stuffItem, this.stuff, STUFF_COLLECTION);
        }

        @Override
        public String displayString() {
            return this.toString();
        }

        @Override
        public Icon icon() {
            return null;
        }

        @Override
        public int compareTo(Junk o) {
            return this.displayString().compareTo(o.displayString());
        }

        public String toString() {
            return "Junk(" + this.stuff + ")";
        }
    }
}

