/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyAspectAdapter;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.DocumentAdapter;

public class DocumentAdapterUITest {
    private TestModel testModel;
    private static final String DEFAULT_NAME = "Scooby Doo";
    private ModifiablePropertyValueModel<TestModel> testModelHolder;
    private ModifiablePropertyValueModel<String> nameHolder;
    private Document nameDocument;
    private Document upperCaseNameDocument;

    public static void main(String[] args) throws Exception {
        new DocumentAdapterUITest().exec();
    }

    private DocumentAdapterUITest() {
    }

    private void exec() throws Exception {
        this.testModel = new TestModel(DEFAULT_NAME);
        this.testModelHolder = new SimplePropertyValueModel((Object)this.testModel);
        this.nameHolder = this.buildNameHolder((PropertyValueModel<TestModel>)this.testModelHolder);
        this.nameDocument = this.buildNameDocument(this.nameHolder);
        this.upperCaseNameDocument = this.buildUpperCaseNameDocument(this.nameHolder);
        this.openWindow();
    }

    private ModifiablePropertyValueModel<String> buildNameHolder(PropertyValueModel<TestModel> vm) {
        return new PropertyAspectAdapter<TestModel, String>(vm, new String[]{"name"}){

            protected String buildValue_() {
                return ((TestModel)((Object)this.subject)).getName();
            }

            protected void setValue_(String value) {
                ((TestModel)((Object)this.subject)).setName(value);
            }
        };
    }

    private Document buildNameDocument(ModifiablePropertyValueModel<String> stringHolder) {
        return new DocumentAdapter(stringHolder);
    }

    private Document buildUpperCaseNameDocument(ModifiablePropertyValueModel<String> stringHolder) {
        return new DocumentAdapter(stringHolder, (Document)this.buildUpperCaseNameDocumentDelegate());
    }

    private AbstractDocument buildUpperCaseNameDocumentDelegate() {
        return new PlainDocument(){

            @Override
            public void insertString(int offset, String string, AttributeSet a) throws BadLocationException {
                if (string == null) {
                    return;
                }
                char[] upper = string.toCharArray();
                int i = 0;
                while (i < upper.length) {
                    upper[i] = Character.toUpperCase(upper[i]);
                    ++i;
                }
                super.insertString(offset, new String(upper), a);
            }
        };
    }

    private void openWindow() {
        JFrame window = new JFrame(this.getClass().getName());
        window.setDefaultCloseOperation(0);
        window.addWindowListener(this.buildWindowListener());
        window.getContentPane().add(this.buildMainPanel(), "Center");
        window.setSize(400, 100);
        window.setVisible(true);
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                System.exit(0);
            }
        };
    }

    private Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.buildTextFieldPanel(), "North");
        mainPanel.add(this.buildControlPanel(), "South");
        return mainPanel;
    }

    private Component buildTextFieldPanel() {
        JPanel taskListPanel = new JPanel(new GridLayout(1, 0));
        taskListPanel.add(this.buildNameTextField());
        taskListPanel.add(this.buildReadOnlyNameTextField());
        taskListPanel.add(this.buildUpperCaseNameTextField());
        return taskListPanel;
    }

    private JTextField buildNameTextField() {
        return new JTextField(this.nameDocument, null, 0);
    }

    private JTextField buildReadOnlyNameTextField() {
        JTextField nameTextField = this.buildNameTextField();
        nameTextField.setEditable(false);
        return nameTextField;
    }

    private JTextField buildUpperCaseNameTextField() {
        return new JTextField(this.upperCaseNameDocument, null, 0);
    }

    private Component buildControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(1, 0));
        controlPanel.add(this.buildResetNameButton());
        controlPanel.add(this.buildClearModelButton());
        controlPanel.add(this.buildRestoreModelButton());
        controlPanel.add(this.buildPrintModelButton());
        return controlPanel;
    }

    private JButton buildResetNameButton() {
        return new JButton(this.buildResetNameAction());
    }

    private Action buildResetNameAction() {
        AbstractAction action = new AbstractAction("reset name"){

            @Override
            public void actionPerformed(ActionEvent event) {
                DocumentAdapterUITest.this.resetName();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void resetName() {
        this.testModel.setName(DEFAULT_NAME);
    }

    private JButton buildClearModelButton() {
        return new JButton(this.buildClearModelAction());
    }

    private Action buildClearModelAction() {
        AbstractAction action = new AbstractAction("clear model"){

            @Override
            public void actionPerformed(ActionEvent event) {
                DocumentAdapterUITest.this.clearModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void clearModel() {
        this.testModelHolder.setValue(null);
    }

    private JButton buildRestoreModelButton() {
        return new JButton(this.buildRestoreModelAction());
    }

    private Action buildRestoreModelAction() {
        AbstractAction action = new AbstractAction("restore model"){

            @Override
            public void actionPerformed(ActionEvent event) {
                DocumentAdapterUITest.this.restoreModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void restoreModel() {
        this.testModelHolder.setValue((Object)this.testModel);
    }

    private JButton buildPrintModelButton() {
        return new JButton(this.buildPrintModelAction());
    }

    private Action buildPrintModelAction() {
        AbstractAction action = new AbstractAction("print model"){

            @Override
            public void actionPerformed(ActionEvent event) {
                DocumentAdapterUITest.this.printModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void printModel() {
        System.out.println("name: " + this.testModel.getName());
    }

    private class TestModel
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";

        public TestModel(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public String toString() {
            return "TestModel(" + this.getName() + ")";
        }
    }
}

