/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyAspectAdapter;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.DateSpinnerModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.swing.ListSpinnerModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.swing.NumberSpinnerModelAdapter;

public class SpinnerModelAdapterUITest {
    private TestModel testModel;
    private ModifiablePropertyValueModel<TestModel> testModelHolder;
    private ModifiablePropertyValueModel<Object> birthDateHolder;
    private SpinnerModel birthDateSpinnerModel;
    private ModifiablePropertyValueModel<Number> ageHolder;
    private SpinnerModel ageSpinnerModel;
    private ModifiablePropertyValueModel<Object> eyeColorHolder;
    private SpinnerModel eyeColorSpinnerModel;

    public static void main(String[] args) throws Exception {
        new SpinnerModelAdapterUITest().exec();
    }

    private SpinnerModelAdapterUITest() {
    }

    private void exec() throws Exception {
        this.testModel = new TestModel();
        this.testModelHolder = new SimplePropertyValueModel((Object)this.testModel);
        this.birthDateHolder = this.buildBirthDateHolder((PropertyValueModel<TestModel>)this.testModelHolder);
        this.birthDateSpinnerModel = this.buildBirthDateSpinnerModel(this.birthDateHolder);
        this.ageHolder = this.buildAgeHolder((PropertyValueModel<TestModel>)this.testModelHolder);
        this.ageSpinnerModel = this.buildAgeSpinnerModel(this.ageHolder);
        this.eyeColorHolder = this.buildEyeColorHolder((PropertyValueModel<TestModel>)this.testModelHolder);
        this.eyeColorSpinnerModel = this.buildEyeColorSpinnerModel(this.eyeColorHolder);
        this.openWindow();
    }

    private ModifiablePropertyValueModel<Object> buildBirthDateHolder(PropertyValueModel<TestModel> vm) {
        return new PropertyAspectAdapter<TestModel, Object>(vm, new String[]{"birthDate"}){

            protected Object buildValue_() {
                return ((TestModel)((Object)this.subject)).getBirthDate();
            }

            protected void setValue_(Object value) {
                ((TestModel)((Object)this.subject)).setBirthDate((Date)value);
            }
        };
    }

    private SpinnerModel buildBirthDateSpinnerModel(ModifiablePropertyValueModel<Object> valueHolder) {
        return new DateSpinnerModelAdapter(valueHolder);
    }

    private ModifiablePropertyValueModel<Number> buildAgeHolder(PropertyValueModel<TestModel> vm) {
        return new PropertyAspectAdapter<TestModel, Number>(vm, new String[]{"age"}){

            protected Number buildValue_() {
                return new Integer(((TestModel)((Object)this.subject)).getAge());
            }

            protected void setValue_(Number value) {
                ((TestModel)((Object)this.subject)).setAge(value.intValue());
            }
        };
    }

    private SpinnerModel buildAgeSpinnerModel(ModifiablePropertyValueModel<Number> valueHolder) {
        return new NumberSpinnerModelAdapter(valueHolder, ((Number)valueHolder.getValue()).intValue(), 0, 150, 1);
    }

    private ModifiablePropertyValueModel<Object> buildEyeColorHolder(PropertyValueModel<TestModel> vm) {
        return new PropertyAspectAdapter<TestModel, Object>(vm, new String[]{"eyeColor"}){

            protected Object buildValue_() {
                return ((TestModel)((Object)this.subject)).getEyeColor();
            }

            protected void setValue_(Object value) {
                ((TestModel)((Object)this.subject)).setEyeColor((String)value);
            }
        };
    }

    private SpinnerModel buildEyeColorSpinnerModel(ModifiablePropertyValueModel<Object> valueHolder) {
        return new ListSpinnerModelAdapter(valueHolder, (Object[])TestModel.VALID_EYE_COLORS);
    }

    private void openWindow() {
        JFrame window = new JFrame(this.getClass().getName());
        window.setDefaultCloseOperation(0);
        window.addWindowListener(this.buildWindowListener());
        window.getContentPane().add(this.buildMainPanel(), "Center");
        window.setSize(600, 100);
        window.setVisible(true);
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                System.exit(0);
            }
        };
    }

    private Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.buildSpinnerPanel(), "North");
        mainPanel.add(this.buildControlPanel(), "South");
        return mainPanel;
    }

    private Component buildSpinnerPanel() {
        JPanel taskListPanel = new JPanel(new GridLayout(1, 0));
        taskListPanel.add(this.buildBirthDateSpinner());
        taskListPanel.add(this.buildAgeSpinner());
        taskListPanel.add(this.buildEyeColorSpinner());
        return taskListPanel;
    }

    private JSpinner buildBirthDateSpinner() {
        return new JSpinner(this.birthDateSpinnerModel);
    }

    private JSpinner buildAgeSpinner() {
        return new JSpinner(this.ageSpinnerModel);
    }

    private JSpinner buildEyeColorSpinner() {
        return new JSpinner(this.eyeColorSpinnerModel);
    }

    private Component buildControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(1, 0));
        controlPanel.add(this.buildResetModelButton());
        controlPanel.add(this.buildClearModelButton());
        controlPanel.add(this.buildRestoreModelButton());
        controlPanel.add(this.buildPrintModelButton());
        return controlPanel;
    }

    private JButton buildResetModelButton() {
        return new JButton(this.buildResetModelAction());
    }

    private Action buildResetModelAction() {
        AbstractAction action = new AbstractAction("reset model"){

            @Override
            public void actionPerformed(ActionEvent event) {
                SpinnerModelAdapterUITest.this.resetModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void resetModel() {
        this.testModel.setBirthDate(TestModel.DEFAULT_BIRTH_DATE);
        this.testModel.setEyeColor(TestModel.DEFAULT_EYE_COLOR);
    }

    private JButton buildClearModelButton() {
        return new JButton(this.buildClearModelAction());
    }

    private Action buildClearModelAction() {
        AbstractAction action = new AbstractAction("clear model"){

            @Override
            public void actionPerformed(ActionEvent event) {
                SpinnerModelAdapterUITest.this.clearModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void clearModel() {
        this.testModelHolder.setValue(null);
    }

    private JButton buildRestoreModelButton() {
        return new JButton(this.buildRestoreModelAction());
    }

    private Action buildRestoreModelAction() {
        AbstractAction action = new AbstractAction("restore model"){

            @Override
            public void actionPerformed(ActionEvent event) {
                SpinnerModelAdapterUITest.this.restoreModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void restoreModel() {
        this.testModelHolder.setValue((Object)this.testModel);
    }

    private JButton buildPrintModelButton() {
        return new JButton(this.buildPrintModelAction());
    }

    private Action buildPrintModelAction() {
        AbstractAction action = new AbstractAction("print model"){

            @Override
            public void actionPerformed(ActionEvent event) {
                SpinnerModelAdapterUITest.this.printModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void printModel() {
        System.out.println("birth date: " + this.testModel.getBirthDate());
        System.out.println("age: " + this.testModel.getAge());
        System.out.println("eyes: " + this.testModel.getEyeColor());
    }

    static class TestModel
    extends AbstractModel {
        private Calendar birthCal = Calendar.getInstance();
        public static final String BIRTH_DATE_PROPERTY = "birthDate";
        public static final String AGE_PROPERTY = "age";
        public static final Date DEFAULT_BIRTH_DATE = new Date();
        public static final int DEFAULT_AGE = 0;
        public static final int MIN_AGE = 0;
        public static final int MAX_AGE = 150;
        private String eyeColor;
        public static final String EYE_COLOR_PROPERTY = "eyeColor";
        public static final String[] VALID_EYE_COLORS = new String[]{"blue", "brown", "green", "hazel", "pink"};
        public static final String DEFAULT_EYE_COLOR = VALID_EYE_COLORS[3];

        TestModel() {
            this(DEFAULT_BIRTH_DATE, DEFAULT_EYE_COLOR);
        }

        public TestModel(Date birthDate, String eyeColor) {
            this.setBirthDate(birthDate);
            this.setEyeColor(eyeColor);
        }

        public Date getBirthDate() {
            return (Date)this.birthCal.getTime().clone();
        }

        public void setBirthDate(Date birthDate) {
            Date oldBirthDate = this.getBirthDate();
            int oldAge = this.getAge();
            this.birthCal.setTimeInMillis(birthDate.getTime());
            int newAge = this.getAge();
            if (newAge < 0 || newAge > 150) {
                throw new IllegalArgumentException(birthDate.toString());
            }
            this.firePropertyChanged(BIRTH_DATE_PROPERTY, oldBirthDate, this.getBirthDate());
            this.firePropertyChanged(AGE_PROPERTY, oldAge, newAge);
        }

        public int getAge() {
            Calendar currentCal = Calendar.getInstance();
            int age = currentCal.get(1) - this.birthCal.get(1);
            if (currentCal.get(2) < this.birthCal.get(2)) {
                --age;
            } else if (currentCal.get(2) == this.birthCal.get(2) && currentCal.get(5) < this.birthCal.get(5)) {
                --age;
            }
            return age;
        }

        public void setAge(int newAge) {
            if (newAge < 0 || newAge > 150) {
                throw new IllegalArgumentException(String.valueOf(newAge));
            }
            int oldAge = this.getAge();
            int delta = newAge - oldAge;
            Calendar newBirthCal = Calendar.getInstance();
            newBirthCal.setTimeInMillis(this.birthCal.getTime().getTime());
            newBirthCal.set(1, newBirthCal.get(1) - delta);
            this.setBirthDate(newBirthCal.getTime());
        }

        public String getEyeColor() {
            return this.eyeColor;
        }

        public void setEyeColor(String eyeColor) {
            if (!ArrayTools.contains((Object[])VALID_EYE_COLORS, (Object)eyeColor)) {
                throw new IllegalArgumentException(eyeColor);
            }
            String old = this.eyeColor;
            this.eyeColor = eyeColor;
            this.firePropertyChanged(EYE_COLOR_PROPERTY, old, eyeColor);
        }

        public String toString() {
            return "TestModel(birth: " + this.getBirthDate() + " - eyes: " + this.eyeColor + ")";
        }
    }
}

