/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.value.AbstractPropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;

public abstract class PropertyValueModelWrapper<V>
extends AbstractPropertyValueModel {
    protected final PropertyValueModel<? extends V> valueModel;
    protected final PropertyChangeListener valueListener;

    protected PropertyValueModelWrapper(PropertyValueModel<? extends V> valueModel) {
        if (valueModel == null) {
            throw new NullPointerException();
        }
        this.valueModel = valueModel;
        this.valueListener = this.buildValueListener();
    }

    protected PropertyChangeListener buildValueListener() {
        return new ValueListener();
    }

    @Override
    protected void engageModel() {
        this.valueModel.addPropertyChangeListener("value", this.valueListener);
    }

    @Override
    protected void disengageModel() {
        this.valueModel.removePropertyChangeListener("value", this.valueListener);
    }

    protected void wrappedValueChanged(PropertyChangeEvent event) {
        this.wrappedValueChanged(event.getOldValue(), event.getNewValue());
    }

    protected void wrappedValueChanged(V oldValue, V newValue) {
        throw new RuntimeException("This method was not overridden.");
    }

    class ValueListener
    extends PropertyChangeAdapter {
        ValueListener() {
        }

        @Override
        public void propertyChanged(PropertyChangeEvent event) {
            PropertyValueModelWrapper.this.wrappedValueChanged(event);
        }
    }
}

