/*******************************************************************************
 * Copyright (c) 1998, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.relational.handles;

import org.eclipse.persistence.tools.db.relational.ELColumn;
import org.eclipse.persistence.tools.db.relational.ELModel;
import org.eclipse.persistence.tools.utility.node.Node;

/**
 * MWColumnHandle is used to isolate the painful bits of code
 * necessary to correctly handle references to MWColumns.
 * Since a MWColumn is nested within the XML file
 * for a MWTable, we need to store a reference to a particular
 * column as a pair of instance variables:
 *   - the name of the containing table
 *   - the name of the column
 *
 * This causes no end of pain when dealing with TopLink, property
 * change listeners, backward-compatibility, etc.
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
public final class MWColumnHandle extends MWHandle {

	/**
	 * This is the actual column.
	 * It is built from the table and column names, below.
	 */
	private volatile ELColumn column;

	/**
	 * The table and column names are transient. They
	 * are used only to hold their values until postProjectBuild()
	 * is called and we can resolve the actual column.
	 * We do not keep these in synch with the column itself because
	 * we cannot know when the column has been renamed etc.
	 */
	private volatile String columnTableName;
	private volatile String columnName;

	// ********** constructors **********

	/**
	 * default constructor - for TopLink use only
	 */
	@SuppressWarnings("unused")
	private MWColumnHandle() {
		super();
	}

	public MWColumnHandle(ELModel parent, NodeReferenceScrubber scrubber) {
		super(parent, scrubber);
	}

	public MWColumnHandle(ELModel parent, ELColumn column, NodeReferenceScrubber scrubber) {
		super(parent, scrubber);
		this.column = column;
	}


	// ********** instance methods **********

	public ELColumn getColumn() {
		return this.column;
	}

	public void setColumn(ELColumn column) {
		this.column = column;
	}

	@Override
	protected Node node() {
		return this.getColumn();
	}

	@Override
	public void toString(StringBuffer sb) {
		if (this.column == null) {
			sb.append("null");
		} else {
			this.column.toString(sb);
		}
	}

	public MWColumnHandle setScrubber(NodeReferenceScrubber scrubber) {
		this.setScrubberInternal(scrubber);
		return this;
	}
}