/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.model.Model;

/**
 * Interface used to abstract collection accessing and
 * change notification and make it more pluggable.
 * <p>
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @param <E> the type of values held by the model
 */
@SuppressWarnings("nls")
public interface CollectionValueModel<E>
	extends Model, Iterable<E>
{

	/**
	 * Return the collection's values.
	 */
	@Override
	Iterator<E> iterator();
		String VALUES = "values";

	/**
	 * Return the size of the collection.
	 */
	int size();
}