/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.reference;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.reference.SimpleObjectReference;

public class SimpleObjectReferenceTests
extends TestCase {
    public SimpleObjectReferenceTests(String name) {
        super(name);
    }

    public void testGetValue() {
        SimpleObjectReference or = new SimpleObjectReference();
        SimpleObjectReferenceTests.assertNull((Object)or.getValue());
        or.setValue((Object)"foo");
        SimpleObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
    }

    public void testValueEqualsObject() {
        SimpleObjectReference or = new SimpleObjectReference();
        SimpleObjectReferenceTests.assertTrue((boolean)or.valueEquals(null));
        SimpleObjectReferenceTests.assertFalse((boolean)or.valueEquals((Object)"foo"));
        or.setValue((Object)"foo");
        SimpleObjectReferenceTests.assertFalse((boolean)or.valueEquals(null));
        SimpleObjectReferenceTests.assertTrue((boolean)or.valueEquals((Object)"foo"));
    }

    public void testValueNotEqualObject() {
        SimpleObjectReference or = new SimpleObjectReference();
        SimpleObjectReferenceTests.assertFalse((boolean)or.valueNotEqual(null));
        SimpleObjectReferenceTests.assertTrue((boolean)or.valueNotEqual((Object)"foo"));
        or.setValue((Object)"foo");
        SimpleObjectReferenceTests.assertTrue((boolean)or.valueNotEqual(null));
        SimpleObjectReferenceTests.assertFalse((boolean)or.valueNotEqual((Object)"foo"));
    }

    public void testIsNull() {
        SimpleObjectReference or = new SimpleObjectReference();
        SimpleObjectReferenceTests.assertTrue((boolean)or.isNull());
        or.setValue((Object)"foo");
        SimpleObjectReferenceTests.assertFalse((boolean)or.isNull());
    }

    public void testIsNotNull() {
        SimpleObjectReference or = new SimpleObjectReference();
        SimpleObjectReferenceTests.assertFalse((boolean)or.isNotNull());
        or.setValue((Object)"foo");
        SimpleObjectReferenceTests.assertTrue((boolean)or.isNotNull());
    }

    public void testSetNull() {
        SimpleObjectReference or = new SimpleObjectReference();
        SimpleObjectReferenceTests.assertNull((Object)or.getValue());
        or.setValue((Object)"foo");
        SimpleObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
        or.setNull();
        SimpleObjectReferenceTests.assertNull((Object)or.getValue());
    }

    public void testClone() {
        SimpleObjectReference or = new SimpleObjectReference((Object)"foo");
        SimpleObjectReference clone = or.clone();
        SimpleObjectReferenceTests.assertEquals((String)"foo", (String)((String)clone.getValue()));
        SimpleObjectReferenceTests.assertNotSame((Object)or, (Object)clone);
    }

    public void testToString() {
        SimpleObjectReference or = new SimpleObjectReference();
        SimpleObjectReferenceTests.assertEquals((String)"[null]", (String)or.toString());
        or.setValue((Object)"foo");
        SimpleObjectReferenceTests.assertEquals((String)"[foo]", (String)or.toString());
    }
}

