/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalFormHelper;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractExternalForm
implements ExternalForm {
    private List<String> attributeNamesOrder;
    private List<String> elementNamesOrder;
    private AbstractExternalForm parent;
    public static final String XMLNS_ATTRIBUTE = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XMLNS_XSI = "xmlns:xsi";
    public static final String XSD_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_VERSION = "version";
    public static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

    protected AbstractExternalForm(AbstractExternalForm parent) {
        this.parent = parent;
        this.initialize();
    }

    public final void acquireReadLock() {
        this.getHelper().acquireReadLock();
    }

    public final Element addChild(AbstractExternalForm parent, String elementName) {
        Element element = parent.getElement();
        if (element == null) {
            element = parent.addSelf();
        }
        return this.addChild(element, elementName, parent.getElementNamesOrder());
    }

    public final Element addChild(AbstractExternalForm parent, String elementName, List<String> elementNamesOrder) {
        Element element = parent.getElement();
        if (element == null) {
            element = parent.addSelf();
        }
        return this.addChild(element, elementName, elementNamesOrder);
    }

    protected Element addChild(Element element, String elementName) {
        return this.addChild(element, elementName, this.getElementNamesOrder());
    }

    public final Element addChild(Element element, String elementName, List<String> elementNamesOrder) {
        Element childElement = this.getHelper().addChild(this, element, elementName, elementNamesOrder);
        this.calculateInsertionIndex(element, childElement, elementName);
        return childElement;
    }

    public final Element addChild(String elementName) {
        Element element = this.getElement();
        if (element == null) {
            element = this.addSelf();
        }
        return this.addChild(element, elementName);
    }

    public final Element addChild(String elementName, List<String> elementNamesOrder) {
        Element element = this.getElement();
        if (element == null) {
            element = this.addSelf();
        }
        return this.addChild(element, elementName, elementNamesOrder);
    }

    public final Element addChildTextNode(Element element, String elementName, String value) {
        return this.addChildTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    public final Element addChildTextNode(Element element, String elementName, String value, List<String> elementNamesOrder) {
        return this.getHelper().addChildTextNode(this, element, elementName, value, elementNamesOrder);
    }

    public final Element addChildTextNode(String elementName, String value) {
        return this.addChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    public final Element addChildTextNode(String elementName, String value, List<String> elementNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return null;
        }
        if (element == null) {
            element = this.addSelf();
        }
        return this.addChildTextNode(element, elementName, value, elementNamesOrder);
    }

    public Element addSelf() {
        return this.addSelf(this.getElementName());
    }

    protected Element addSelf(List<String> elementNamesOrder) {
        return this.addSelf(this.getElementName(), elementNamesOrder);
    }

    protected Element addSelf(String elementName) {
        return this.addSelf(elementName, this.getParent().getElementNamesOrder());
    }

    public Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.addChild(this.getParent(), elementName, elementNamesOrder);
    }

    public final void addXmlns(Element ownerElement, String prefix, String uri) {
        ownerElement.setAttributeNS(XMLNS_URI, "xmlns:" + prefix, uri);
    }

    protected List<String> buildAttributeNamesOrder() {
        return Collections.emptyList();
    }

    protected List<String> buildElementNamesOrder() {
        return Collections.emptyList();
    }

    public final String buildQualifiedName(String name) {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return name;
        }
        return String.valueOf(prefix) + ":" + name;
    }

    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
    }

    public final Element elementOfInsertion(Element element, String elementName, List<String> elementNamesOrder) {
        return (Element)this.nodeOfInsertion(element, this.getChildren(element), elementName, elementNamesOrder);
    }

    public final Text findTextNode(Element element) {
        NodeList children = element.getChildNodes();
        if (children == null) {
            return null;
        }
        int index = children.getLength();
        while (--index >= 0) {
            Node childNode = children.item(index);
            if (!this.isText(childNode)) continue;
            return (Text)childNode;
        }
        return null;
    }

    public final List<Node> getAllChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.getAllChildren(element);
        }
        return Collections.emptyList();
    }

    public final List<Node> getAllChildren(Node node) {
        this.acquireReadLock();
        try {
            ArrayList<Node> children = new ArrayList<Node>();
            NodeList childrenList = node.getChildNodes();
            if (childrenList != null) {
                int index = 0;
                int count = childrenList.getLength();
                while (index < count) {
                    children.add(childrenList.item(index));
                    ++index;
                }
            }
            ArrayList<Node> arrayList = children;
            return arrayList;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final int getAllChildrenSize() {
        Element element = this.getElement();
        if (element != null) {
            return this.getAllChildrenSize(element);
        }
        return 0;
    }

    public final int getAllChildrenSize(Node node) {
        this.acquireReadLock();
        try {
            NodeList childrenList = node.getChildNodes();
            int n = childrenList != null ? childrenList.getLength() : 0;
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final String getAttribute(Element element, String attributeName) {
        this.acquireReadLock();
        try {
            if (element.hasAttribute(attributeName)) {
                String string = element.getAttribute(attributeName);
                return string;
            }
            return null;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final String getAttribute(String attributeName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getAttribute(element, attributeName);
        }
        return null;
    }

    public final List<String> getAttributeNamesOrder() {
        return this.attributeNamesOrder;
    }

    public final String getAttributeNS(Element element, String attributeName) {
        this.acquireReadLock();
        try {
            if (element.hasAttributeNS(XSI_URI, attributeName)) {
                String string = element.getAttributeNS(XSI_URI, attributeName);
                return string;
            }
            return null;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final String getAttributeNS(String attributeName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getAttributeNS(element, attributeName);
        }
        return null;
    }

    public final List<Attr> getAttributes(Element element) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        NamedNodeMap map = element.getAttributes();
        if (map != null) {
            int index = 0;
            int count = map.getLength();
            while (index < count) {
                Node node = map.item(index);
                if (this.isAttribute(node)) {
                    attributes.add((Attr)node);
                }
                ++index;
            }
        }
        return attributes;
    }

    public final TextRange getAttributeTextRange(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        return this.getHelper().getTextRange(this, attribute);
    }

    public final TextRange getAttributeTextRange(Element element, String attributeName) {
        this.acquireReadLock();
        try {
            if (element.hasAttribute(attributeName)) {
                Attr attribute = element.getAttributeNode(attributeName);
                TextRange textRange = this.getAttributeTextRange(attribute);
                return textRange;
            }
            TextRange textRange = this.getTextRange(element);
            return textRange;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final TextRange getAttributeTextRange(String attributeName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getAttributeTextRange(element, attributeName);
        }
        return null;
    }

    public final Boolean getBooleanAttribute(Element element, String attributeName) {
        String value = this.getAttribute(element, attributeName);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public final Boolean getBooleanAttribute(String attributeName) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return this.getBooleanAttribute(element, attributeName);
    }

    public final Element getChild(AbstractExternalForm parent, String elementName) {
        return this.getChild((Node)parent.getElement(), elementName);
    }

    public final Element getChild(AbstractExternalForm parent, String elementName, int index) {
        return this.getChild(parent.getElement(), elementName, index);
    }

    public final Element getChild(Node node, int index) {
        List<Element> children = this.getChildren(node);
        if (index >= children.size()) {
            return null;
        }
        return children.get(index);
    }

    public final Element getChild(Node node, String elementName) {
        this.acquireReadLock();
        try {
            for (Element child : this.getChildren(node)) {
                if (!ObjectTools.equals((Object)child.getNodeName(), (Object)elementName)) continue;
                Element element = child;
                return element;
            }
            return null;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final Element getChild(Node node, String elementName, int index) {
        if (index < 0) {
            return null;
        }
        List<Element> children = this.getChildren(node, elementName);
        if (index >= children.size()) {
            return null;
        }
        return children.get(index);
    }

    public final Element getChild(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            element = this.getChild((Node)element, elementName);
        }
        return element;
    }

    public final Element getChild(String elementName, int index) {
        Element element = this.getElement();
        if (element != null) {
            element = this.getChild(element, elementName, index);
        }
        return element;
    }

    public final String getChildAttribute(Node element, String childName, String attributeName) {
        Element childNode = this.getChild(element, childName);
        if (childNode == null) {
            return null;
        }
        return this.getAttribute(childNode, attributeName);
    }

    public final String getChildAttribute(String childName, String attributeName) {
        Element element = this.getChild(childName);
        if (element != null) {
            return this.getAttribute(element, attributeName);
        }
        return null;
    }

    public final TextRange getChildAttributeTextRange(String childName, String attributeName) {
        Element element = this.getChild(childName);
        if (element != null) {
            return this.getAttributeTextRange(element, attributeName);
        }
        return null;
    }

    public final Boolean getChildBooleanAttribute(Node element, String elementName, String attributeName) {
        String value = this.getChildAttribute(element, elementName, attributeName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public final Boolean getChildBooleanAttribute(String elementName, String attributeName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildBooleanAttribute(element, elementName, attributeName);
        }
        return null;
    }

    public final Boolean getChildBooleanNode(Node element, String elementName) {
        String value = this.getChildTextNode(element, elementName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public final Boolean getChildBooleanNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildBooleanNode(element, elementName);
        }
        return null;
    }

    public final <T extends Enum<T>> T getChildEnumAttribute(Node node, String elementName, String attributeName, Class<T> enumClass) {
        String value = this.getChildAttribute(node, elementName, attributeName);
        if (value != null) {
            try {
                return Enum.valueOf(enumClass, value);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public final <T extends Enum<T>> T getChildEnumAttribute(String elementName, String attributeName, Class<T> enumClass) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildEnumAttribute(element, elementName, attributeName, enumClass);
        }
        return null;
    }

    public final <T extends Enum<T>> T getChildEnumNode(Node node, String elementName, Class<T> enumClass) {
        String value = this.getChildTextNode(node, elementName);
        if (value != null) {
            try {
                return Enum.valueOf(enumClass, value);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public final <T extends Enum<T>> T getChildEnumNode(String elementName, Class<T> enumClass) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildEnumNode(element, elementName, enumClass);
        }
        return null;
    }

    public final Integer getChildIntegerAttribute(Node element, String elementName, String attributeName) {
        String value = this.getChildAttribute(element, elementName, attributeName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Integer getChildIntegerAttribute(String elementName, String attributeName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildIntegerAttribute(element, elementName, attributeName);
        }
        return null;
    }

    public final Integer getChildIntegerNode(Node element, String elementName) {
        String value = this.getChildTextNode(element, elementName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Integer getChildIntegerNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildIntegerNode(element, elementName);
        }
        return null;
    }

    public final List<Element> getChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildren(element);
        }
        return Collections.emptyList();
    }

    public final List<Element> getChildren(Node node) {
        this.acquireReadLock();
        try {
            ArrayList<Element> children = new ArrayList<Element>();
            NodeList childrenList = node.getChildNodes();
            if (childrenList != null) {
                int index = 0;
                int count = childrenList.getLength();
                while (index < count) {
                    Node child = childrenList.item(index);
                    if (this.isElement(child)) {
                        children.add((Element)child);
                    }
                    ++index;
                }
            }
            ArrayList<Element> arrayList = children;
            return arrayList;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final List<Element> getChildren(Node node, Collection<String> elementNames) {
        this.acquireReadLock();
        try {
            List<Element> children = this.getChildren(node);
            Iterator<Element> iter = children.iterator();
            while (iter.hasNext()) {
                Element element = iter.next();
                String elementName = element.getNodeName();
                if (elementNames.contains(elementName)) continue;
                iter.remove();
            }
            List<Element> list = children;
            return list;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final List<Element> getChildren(Node node, String elementName) {
        this.acquireReadLock();
        try {
            List<Element> children = this.getChildren(node);
            Iterator<Element> iter = children.iterator();
            while (iter.hasNext()) {
                Element element = iter.next();
                if (!ObjectTools.notEquals((Object)element.getNodeName(), (Object)elementName)) continue;
                iter.remove();
            }
            List<Element> list = children;
            return list;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final List<Element> getChildren(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildren((Node)element, elementName);
        }
        return Collections.emptyList();
    }

    public final int getChildrenSize() {
        return this.getChildren().size();
    }

    public final int getChildrenSize(Node node) {
        return this.getChildren(node).size();
    }

    public final int getChildrenSize(Node element, Collection<String> elementNames) {
        return this.getChildren(element, elementNames).size();
    }

    public final int getChildrenSize(Node element, String elementName) {
        return this.getChildren(element, elementName).size();
    }

    public final int getChildrenSize(String elementName) {
        return this.getChildren(elementName).size();
    }

    public final List<String> getChildrenTextNode(Node node, String elementName) {
        this.acquireReadLock();
        try {
            ArrayList<String> values = new ArrayList<String>();
            for (Element element : this.getChildren(node, elementName)) {
                values.add(element.getTextContent());
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final List<String> getChildrenTextNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildrenTextNode(element, elementName);
        }
        return Collections.emptyList();
    }

    public final String getChildTextNode(Node node, String elementName) {
        Element child = this.getChild(node, elementName);
        if (child != null) {
            return this.getTextNode(child);
        }
        return null;
    }

    public final String getChildTextNode(Node node, String elementName, int index) {
        Element element = this.getChild(node, elementName, index);
        if (element != null) {
            return this.getTextNode(element);
        }
        return null;
    }

    public final Element getChildTextNode(Node node, String elementName, int index, String text) {
        int nodeIndex = 0;
        for (Element child : this.getChildren(node, elementName)) {
            String childText = this.getTextNode(child);
            if (!childText.equals(text)) continue;
            if (nodeIndex == index) {
                return child;
            }
            ++nodeIndex;
        }
        return null;
    }

    public final Element getChildTextNode(Node node, String elementName, String text) {
        for (Element child : this.getChildren(node, elementName)) {
            String childText = this.getTextNode(child);
            if (!childText.equals(text)) continue;
            return child;
        }
        return null;
    }

    public final String getChildTextNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildTextNode(element, elementName);
        }
        return null;
    }

    public final String getChildTextNode(String elementName, int index) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildTextNode((Node)element, elementName, index);
        }
        return null;
    }

    public final String getChildTextNode(String childName, String elementName) {
        Element child = this.getChild(childName);
        if (child != null) {
            return this.getChildTextNode(child, elementName);
        }
        return null;
    }

    public final TextRange getChildTextNodeTextRange(Node node, String elementName) {
        Element child = this.getChild(node, elementName);
        if (child != null) {
            return this.getTextNodeTextRange(child);
        }
        return null;
    }

    public final TextRange getChildTextNodeTextRange(Node node, String elementName, int index, String textNode) {
        Element child = this.getChildTextNode(node, elementName, index, textNode);
        if (child != null) {
            return this.getTextNodeTextRange(child);
        }
        return null;
    }

    public final TextRange getChildTextNodeTextRange(Node node, String elementName, String textNode) {
        Element child = this.getChildTextNode(node, elementName, textNode);
        if (child != null) {
            return this.getTextNodeTextRange(child);
        }
        return null;
    }

    public final TextRange getChildTextNodeTextRange(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildTextNodeTextRange(element, elementName);
        }
        return null;
    }

    public final TextRange getChildTextNodeTextRange(String elementName, int index) {
        Element element = this.getChild(elementName, index);
        if (element != null) {
            return this.getTextNodeTextRange(element);
        }
        return null;
    }

    public final TextRange getChildTextNodeTextRange(String elementName, int index, String textNode) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildTextNodeTextRange(element, elementName, index, textNode);
        }
        return null;
    }

    public final TextRange getChildTextNodeTextRange(String elementName, String textNode) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildTextNodeTextRange(element, elementName, textNode);
        }
        return null;
    }

    public final TextRange getChildTextRange(String childName) {
        Element element = this.getChild(childName);
        if (element != null) {
            return this.getTextRange(element);
        }
        return null;
    }

    public final Document getDocument() {
        return this.getHelper().getDocument();
    }

    protected Element getElement() {
        return this.getChild(this.getParent(), this.getElementName());
    }

    protected abstract String getElementName();

    public final List<String> getElementNamesOrder() {
        return this.elementNamesOrder;
    }

    public final TextRange getElementNameTextRange(Element element) {
        if (element == null) {
            return null;
        }
        return this.getHelper().getElementNameTextRange(this, element);
    }

    public final <T extends Enum<T>> T getEnumAttribute(Element element, String attributeName, Class<T> enumClass) {
        String value = this.getAttribute(element, attributeName);
        if (value != null) {
            try {
                return Enum.valueOf(enumClass, value);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public final <T extends Enum<T>> T getEnumAttribute(String attributeName, Class<T> enumClass) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return this.getEnumAttribute(element, attributeName, enumClass);
    }

    protected ExternalFormHelper getHelper() {
        return this.getRoot().getHelper();
    }

    public final Integer getIntegerAttribute(Element element, String attributeName) {
        String value = this.getAttribute(attributeName);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public final Integer getIntegerAttribute(String attributeName) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return this.getIntegerAttribute(element, attributeName);
    }

    public final String getNamespace() {
        Element element = this.getRootElement();
        if (element != null) {
            return this.getAttribute(element, XMLNS_ATTRIBUTE);
        }
        return null;
    }

    public final String getNodeName(Node node) {
        this.acquireReadLock();
        try {
            String string = node.getNodeName();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public AbstractExternalForm getParent() {
        return this.parent;
    }

    public final Element getParentElement() {
        return this.getParent().getElement();
    }

    public final String getPrefix() {
        Element element = this.getRootElement();
        this.acquireReadLock();
        try {
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                int index = attributes.getLength();
                while (--index >= 0) {
                    Node node = attributes.item(index);
                    String localName = node.getNodeName();
                    String value = node.getNodeValue();
                    if (localName == null || !localName.startsWith("xmlns:") || !XSI_URI.equals(value)) continue;
                    String string = localName.substring("xmlns:".length());
                    return string;
                }
            }
            return null;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final AbstractExternalForm getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public final Element getRootElement() {
        String rootElementName;
        Document document = this.getDocument();
        Element element = this.getChild((Node)document, rootElementName = this.getRoot().getElementName());
        if (element == null) {
            for (Element child : this.getChildren(document)) {
                if (!ObjectTools.notEquals((Object)child.getNodeName(), (Object)rootElementName)) continue;
                this.setElementName(child, rootElementName);
                return this.getRootElement();
            }
        }
        return element;
    }

    public final String getSchemaLocation() {
        return this.getAttribute(XSI_SCHEMA_LOCATION);
    }

    public final String getTextNode() {
        Element element = this.getElement();
        if (element != null) {
            return this.getTextNode(element);
        }
        return null;
    }

    public final String getTextNode(Node element) {
        this.acquireReadLock();
        try {
            String string = element.getTextContent();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final TextRange getTextNodeTextRange(Node element) {
        if (element == null) {
            return this.getParent().getTextRange();
        }
        return this.getHelper().getTextNodeTextRange(this, element);
    }

    @Override
    public final TextRange getTextRange() {
        Element element = this.getElement();
        if (element != null) {
            return this.getTextRange(element);
        }
        AbstractExternalForm parent = this.getParent();
        if (parent != null) {
            return parent.getTextRange();
        }
        return null;
    }

    public final TextRange getTextRange(Element element) {
        return this.getHelper().getTextRange(this, element);
    }

    public final String getVersion() {
        return this.getAttribute(XSD_VERSION);
    }

    public final boolean hasAnyChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.hasAnyChildren(element);
        }
        return false;
    }

    public final boolean hasAnyChildren(Node node) {
        return this.getAllChildrenSize(node) > 0;
    }

    public final boolean hasAnything() {
        Element element = this.getElement();
        if (element != null) {
            return this.hasChildren(element) || this.hasAttributes(element);
        }
        return false;
    }

    public final boolean hasAttribute(Element element, String elementName) {
        return this.getAttribute(element, elementName) != null;
    }

    public final boolean hasAttribute(String attributeName) {
        return this.getAttribute(attributeName) != null;
    }

    public final boolean hasAttributeNS(Element element, String elementName) {
        return this.getAttributeNS(element, elementName) != null;
    }

    public final boolean hasAttributeNS(String elementName) {
        return this.getAttributeNS(elementName) != null;
    }

    public final boolean hasAttributes() {
        Element element = this.getElement();
        if (element != null) {
            return this.hasAttributes(element);
        }
        return false;
    }

    public final boolean hasAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return false;
        }
        return attributes.getLength() > 0;
    }

    public final boolean hasChild(Element element, String elementName) {
        return this.getChild((Node)element, elementName) != null;
    }

    public final boolean hasChild(Element element, String elementName, int index) {
        return this.getChild(element, elementName, index) != null;
    }

    public final boolean hasChild(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.hasChild(element, elementName);
        }
        return false;
    }

    public final boolean hasChild(String elementName, int index) {
        Element element = this.getElement();
        if (element != null) {
            return this.hasChild(element, elementName, index);
        }
        return false;
    }

    public final boolean hasChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.hasChildren(element);
        }
        return false;
    }

    public final boolean hasChildren(Element element) {
        this.acquireReadLock();
        try {
            NodeList childrenList = element.getChildNodes();
            int count = 0;
            if (childrenList != null) {
                int index = childrenList.getLength();
                while (--index >= 0) {
                    Node child = childrenList.item(index);
                    if (!this.isElement(child)) continue;
                    ++count;
                }
                boolean bl = count > 0;
                return bl;
            }
            return false;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public final boolean hasElement() {
        return this.getElement() != null;
    }

    protected final int index(Element parent, Element child, String elementName) {
        return this.getChildren((Node)parent, elementName).indexOf(child);
    }

    protected void initialize() {
        this.attributeNamesOrder = this.buildAttributeNamesOrder();
        this.elementNamesOrder = this.buildElementNamesOrder();
    }

    protected final boolean isAttribute(Node node) {
        return this.isNodeType(node, 2);
    }

    protected final boolean isElement(Node node) {
        return this.isNodeType(node, 1);
    }

    protected final boolean isNodeType(Node node, int type) {
        return node != null && node.getNodeType() == type;
    }

    protected final boolean isText(Node node) {
        return this.isNodeType(node, 3);
    }

    public final Node nodeOfInsertion(Element element, List<? extends Node> children, String nodeName, List<String> namesOrder) {
        if (namesOrder.isEmpty()) {
            return null;
        }
        int count = namesOrder.size();
        for (Node node : children) {
            String childName = this.getNodeName(node);
            int index = namesOrder.indexOf(nodeName) + 1;
            while (index < count) {
                String name = namesOrder.get(index);
                if (ObjectTools.equals((Object)childName, (Object)name)) {
                    return node;
                }
                ++index;
            }
        }
        return null;
    }

    public final void releaseReadLock() {
        this.getHelper().releaseReadLock();
    }

    public final void remove(Element element) {
        Element parent = this.getElement();
        if (parent != null) {
            this.remove(parent, element);
        }
    }

    public final void remove(Element element, Element childElement) {
        this.getHelper().remove(this, element, childElement);
    }

    public final void removeChild(AbstractExternalForm parent, String elementName, int index) {
        this.removeChild(parent.getElement(), elementName, index);
    }

    public final void removeChild(Element element, int index) {
        Element childElement = this.getChild((Node)element, index);
        if (childElement != null) {
            this.remove(element, childElement);
        }
    }

    public final void removeChild(Element element, String elementName) {
        Element childElement = this.getChild((Node)element, elementName);
        if (childElement != null) {
            this.remove(element, childElement);
        }
    }

    public final void removeChild(Element element, String elementName, int index) {
        Element childElement = this.getChild(element, elementName, index);
        if (childElement != null) {
            this.remove(element, childElement);
        }
    }

    public final void removeChild(String elementName) {
        Element element = this.getChild(elementName);
        if (element != null) {
            this.remove(this.getElement(), element);
        }
    }

    public final void removeChild(String elementName, int index) {
        this.removeChild(this.getElement(), elementName, index);
    }

    public final void removeChildren(Node node, String elementName) {
        this.getHelper().removeChildren(this, node, elementName);
    }

    public final void removeChildren(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            this.removeChildren(element, elementName);
        }
    }

    public void removeSelf() {
        Element element = this.getElement();
        if (this.parent != null && element != null) {
            this.parent.remove(element);
        }
    }

    public final void setAttribute(Element element, String attributeName, Boolean value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(Element element, String attributeName, Boolean value, List<String> attributeNamesOrder) {
        this.setAttribute(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttribute(Element element, String attributeName, Enum<?> value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(Element element, String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        this.setAttribute(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttribute(Element element, String attributeName, Number value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(Element element, String attributeName, Number value, List<String> attributeNamesOrder) {
        this.setAttribute(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttribute(Element element, String attributeName, String value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(Element element, String attributeName, String value, List<String> attributeNamesOrder) {
        this.getHelper().setAttribute(this, element, attributeName, value, attributeNamesOrder);
    }

    public final void setAttribute(String attributeName, Boolean value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(String attributeName, Boolean value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    public final void setAttribute(String attributeName, Enum<?> value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    public final void setAttribute(String attributeName, Number value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(String attributeName, Number value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    public final void setAttribute(String attributeName, String value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttribute(String attributeName, String value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    public final void setAttributeNS(Element element, String attributeName, Boolean value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(Element element, String attributeName, Boolean value, List<String> attributeNamesOrder) {
        this.setAttributeNS(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttributeNS(Element element, String attributeName, Enum<?> value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(Element element, String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        this.setAttributeNS(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttributeNS(Element element, String attributeName, Number value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(Element element, String attributeName, Number value, List<String> attributeNamesOrder) {
        this.setAttributeNS(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttributeNS(Element element, String attributeName, String value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(Element element, String attributeName, String value, List<String> attributeNamesOrder) {
        this.getHelper().setAttributeNS(this, element, attributeName, value, attributeNamesOrder);
    }

    public final void setAttributeNS(String attributeName, Boolean value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(String attributeName, Boolean value, List<String> attributeNamesOrder) {
        this.setAttributeNS(attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttributeNS(String attributeName, Enum<?> value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        this.setAttributeNS(attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttributeNS(String attributeName, Number value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(String attributeName, Number value, List<String> attributeNamesOrder) {
        this.setAttributeNS(attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    public final void setAttributeNS(String attributeName, String value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    public final void setAttributeNS(String attributeName, String value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttributeNS(element, attributeName, value, attributeNamesOrder);
    }

    public final void setElementName(Element element, String elementName) {
        this.getHelper().setElementName(this, element, elementName, this.getElementNamesOrder());
    }

    public final void setNamespace(String uri) {
        this.getHelper().setNamespace(this, uri);
    }

    public final void setSchemaLocation(String uri) {
        this.getHelper().setSchemaLocation(this, uri);
    }

    public final void setTextNode(Element element, String value) {
        this.updateTextNode(element, this.getElementName(), value);
    }

    public final void setTextNode(String value) {
        this.updateTextNode(this.getParent().getElement(), this.getElementName(), value, this.getParent().getElementNamesOrder());
    }

    public final void setVersion(String version) {
        this.setAttribute(XSD_VERSION, version);
    }

    public final void updateChildAttribute(String childName, String attributeName, Boolean value) {
        this.updateChildAttribute(childName, attributeName, value != null ? value.toString() : null);
    }

    public final void updateChildAttribute(String childName, String attributeName, Enum<?> value) {
        this.updateChildAttribute(childName, attributeName, value != null ? value.name() : null);
    }

    public final void updateChildAttribute(String childName, String attributeName, Number value) {
        this.updateChildAttribute(childName, attributeName, value != null ? value.toString() : null);
    }

    public final void updateChildAttribute(String childName, String attributeName, String value) {
        Element element = this.getChild(childName);
        if (element == null && value != null) {
            element = this.addChild(childName);
        }
        if (value != null) {
            this.setAttribute(element, attributeName, value, Collections.<String>emptyList());
        } else if (element != null) {
            this.removeChild(childName);
        }
    }

    public final void updateChildChildTextNode(String parentChildName, String childName, Boolean value) {
        this.updateChildChildTextNode(parentChildName, childName, value != null ? value.toString() : null);
    }

    public final void updateChildChildTextNode(String parentChildName, String childName, Enum<?> value) {
        this.updateChildChildTextNode(parentChildName, childName, value != null ? value.name() : null);
    }

    public final void updateChildChildTextNode(String parentChildName, String childName, Number value) {
        this.updateChildChildTextNode(parentChildName, childName, value != null ? value.toString() : null);
    }

    public final void updateChildChildTextNode(String parentChildName, String childName, String value) {
        Element element = this.getChild(parentChildName);
        if (element == null && value != null) {
            element = this.addChild(parentChildName);
        }
        this.updateTextNode(element, childName, value);
    }

    public final void updateChildTextNode(String elementName, Boolean value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    public final void updateChildTextNode(String elementName, Boolean value, List<String> elementNamesOrder) {
        this.updateChildTextNode(elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    public final void updateChildTextNode(String elementName, Enum<?> value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    public final void updateChildTextNode(String elementName, Enum<?> value, List<String> elementNamesOrder) {
        this.updateChildTextNode(elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    public final void updateChildTextNode(String elementName, Number value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    public final void updateChildTextNode(String elementName, Number value, List<String> elementNamesOrder) {
        this.updateChildTextNode(elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    public final void updateChildTextNode(String elementName, String value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    public final void updateChildTextNode(String elementName, String value, List<String> elementNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.updateTextNode(element, elementName, value, elementNamesOrder);
    }

    public final void updateTextNode(Element element, String elementName, Boolean value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    public final void updateTextNode(Element element, String elementName, Boolean value, List<String> elementNamesOrder) {
        this.updateTextNode(element, elementName, value == null ? null : value.toString(), elementNamesOrder);
    }

    public final void updateTextNode(Element element, String elementName, Enum<?> value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    public final void updateTextNode(Element element, String elementName, Enum<?> value, List<String> elementNamesOrder) {
        this.updateTextNode(element, elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    public final void updateTextNode(Element element, String elementName, Number value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    public final void updateTextNode(Element element, String elementName, Number value, List<String> elementNamesOrder) {
        this.updateTextNode(element, elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    public final void updateTextNode(Element element, String elementName, String value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    public final void updateTextNode(Element element, String elementName, String value, List<String> elementNamesOrder) {
        boolean valueNotEmpty;
        Element childElement = this.getChild((Node)element, elementName);
        if (childElement != null && value == null) {
            this.remove(element, childElement);
            return;
        }
        boolean bl = valueNotEmpty = !StringTools.isBlank((String)value);
        if (childElement == null && valueNotEmpty) {
            this.addChildTextNode(element, elementName, value, elementNamesOrder);
        } else if (childElement != null && valueNotEmpty) {
            this.getHelper().updateTextNode(this, elementName, childElement, value);
        }
    }
}

