/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.annotations.ChangeTrackingType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalProperty;
import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessMethods;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalCloneCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalIDMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalInstantiationCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSql;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransientMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.AccessMethods;
import org.eclipse.persistence.tools.mapping.orm.dom.AssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicMapMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ClassConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.CloneCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.dom.CopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.dom.ElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.InstantiationCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.dom.ManyToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ManyToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Mapping;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSql;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.OneToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.OneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Property;
import org.eclipse.persistence.tools.mapping.orm.dom.StructConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.TransientMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.TypeConverter;
import org.eclipse.persistence.tools.utility.NameTools;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Embeddable
extends AbstractExternalForm
implements ExternalEmbeddable {
    private int index;
    private List<String> mappingElementNamesOrder;

    Embeddable(ORMConfiguration parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public final ExternalAccessMethods addAccessMethods(String getMethodName, String setMethodName) {
        AccessMethods accessMethods = this.buildAccessMethods();
        accessMethods.addSelf();
        accessMethods.setGetMethod(getMethodName);
        accessMethods.setSetMethod(setMethodName);
        return accessMethods;
    }

    @Override
    public ExternalAssociationOverride addAssociationOverride(String name) {
        AssociationOverride associationOverride = this.buildAssociationOverride(-1);
        associationOverride.addSelf();
        associationOverride.setName(name);
        return associationOverride;
    }

    @Override
    public ExternalAttributeOverride addAttributeOverride(String name) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(-1);
        attributeOverride.addSelf();
        attributeOverride.setName(name);
        return attributeOverride;
    }

    @Override
    public final ExternalBasicCollectionMapping addBasicCollectionMapping(String name) {
        BasicCollectionMapping mapping = this.buildBasicCollectionMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalBasicMapMapping addBasicMapMapping(String name) {
        BasicMapMapping mapping = this.buildBasicMapMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalBasicMapping addBasicMapping(String name) {
        BasicMapping mapping = this.buildBasicMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalCloneCopyPolicy addCloneCopyPolicy() {
        CloneCopyPolicy cloneCopyPolicy = this.buildCloneCopyPolicy();
        cloneCopyPolicy.addSelf();
        return cloneCopyPolicy;
    }

    @Override
    public final ExternalClassConverter addConverter() {
        ClassConverter converter = this.buildConverter(-1);
        converter.addSelf();
        return converter;
    }

    @Override
    public final ExternalCopyPolicy addCopyPolicy() {
        CopyPolicy copyPolicy = this.buildCopyPolicy();
        copyPolicy.addSelf();
        return copyPolicy;
    }

    @Override
    public final ExternalElementCollectionMapping addElementCollectionMapping(String name) {
        ElementCollectionMapping mapping = this.buildElementCollectionMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalEmbeddedMapping addEmbeddedMapping(String name) {
        EmbeddedMapping mapping = this.buildEmbeddedMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public ExternalIDMapping addIdMapping(String name) {
        throw new UnsupportedOperationException("An ID mapping is not supported on an embeddable.");
    }

    @Override
    public final ExternalInstantiationCopyPolicy addInstantiationCopyPolicy() {
        InstantiationCopyPolicy instantiationCopyPolicy = this.buildInstantiationCopyPolicy();
        instantiationCopyPolicy.addSelf();
        return instantiationCopyPolicy;
    }

    @Override
    public final ExternalManyToManyMapping addManyToManyMapping(String name) {
        ManyToManyMapping mapping = this.buildManyToManyMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalManyToOneMapping addManyToOneMapping(String name) {
        ManyToOneMapping mapping = this.buildManyToOneMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalNoSql addNoSql() {
        NoSql noSql = this.buildNoSql();
        noSql.addSelf();
        return noSql;
    }

    @Override
    public final ExternalObjectTypeConverter addObjectTypeConverter() {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(-1);
        converter.addSelf();
        return converter;
    }

    @Override
    public final ExternalOneToManyMapping addOneToManyMapping(String name) {
        OneToManyMapping mapping = this.buildOneToManyMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalOneToOneMapping addOneToOneMapping(String name) {
        OneToOneMapping mapping = this.buildOneToOneMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalProperty addProperty(String name, String value) {
        Property property = this.buildProperty(-1);
        property.addSelf();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    @Override
    public final ExternalStructConverter addStructConverter() {
        StructConverter converter = this.buildStructConverter(-1);
        converter.addSelf();
        return converter;
    }

    @Override
    public final ExternalTransientMapping addTransientMapping(String name) {
        TransientMapping mapping = this.buildTransientMapping();
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalTypeConverter addTypeConverter() {
        TypeConverter converter = this.buildTypeConverter(-1);
        converter.addSelf();
        return converter;
    }

    @Override
    public List<ExternalAssociationOverride> associationOverrides() {
        int count = this.associationOverridesSize();
        ArrayList<ExternalAssociationOverride> associationOverrides = new ArrayList<ExternalAssociationOverride>(count);
        int index = 0;
        while (index < count) {
            associationOverrides.add(this.buildAssociationOverride(index));
            ++index;
        }
        return associationOverrides;
    }

    @Override
    public int associationOverridesSize() {
        return this.getChildrenSize("association-override");
    }

    @Override
    public List<ExternalAttributeOverride> attributeOverrides() {
        int count = this.attributeOverridesSize();
        ArrayList<ExternalAttributeOverride> attributeOverrides = new ArrayList<ExternalAttributeOverride>(count);
        int index = 0;
        while (index < count) {
            attributeOverrides.add(this.buildAttributeOverride(index));
            ++index;
        }
        return attributeOverrides;
    }

    @Override
    public int attributeOverridesSize() {
        return this.getChildrenSize("attribute-override");
    }

    private AccessMethods buildAccessMethods() {
        return new AccessMethods(this);
    }

    private AssociationOverride buildAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("class");
        names.add("parent-class");
        names.add("access");
        names.add("metadata-complete");
        names.add("exclude-default-mappings");
        return names;
    }

    private AttributeOverride buildAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    private BasicCollectionMapping buildBasicCollectionMapping() {
        return new BasicCollectionMapping(this);
    }

    private BasicMapMapping buildBasicMapMapping() {
        return new BasicMapMapping(this);
    }

    private BasicMapping buildBasicMapping() {
        return new BasicMapping(this);
    }

    private CloneCopyPolicy buildCloneCopyPolicy() {
        return new CloneCopyPolicy(this);
    }

    private ClassConverter buildConverter(int index) {
        return new ClassConverter(this, index);
    }

    private CopyPolicy buildCopyPolicy() {
        return new CopyPolicy(this);
    }

    private ElementCollectionMapping buildElementCollectionMapping() {
        return new ElementCollectionMapping(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("access-methods");
        names.add("customizer");
        names.add("change-tracking");
        names.add("struct");
        names.add("no-sql");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("serialized-converter");
        names.add("struct-converter");
        names.add("copy-policy");
        names.add("instantiation-copy-policy");
        names.add("clone-copy-policy");
        names.add("oracle-object");
        names.add("oracle-array");
        names.add("plsql-record");
        names.add("plsql-table");
        names.add("property");
        names.add("attribute-override");
        names.add("association-override");
        names.add("attributes");
        return names;
    }

    private EmbeddedMapping buildEmbeddedMapping() {
        return new EmbeddedMapping(this);
    }

    private InstantiationCopyPolicy buildInstantiationCopyPolicy() {
        return new InstantiationCopyPolicy(this);
    }

    private ManyToManyMapping buildManyToManyMapping() {
        return new ManyToManyMapping(this);
    }

    private ManyToOneMapping buildManyToOneMapping() {
        return new ManyToOneMapping(this);
    }

    Mapping buildMapping(String elementName) {
        if (ObjectTools.equals((Object)elementName, (Object)"basic")) {
            return this.buildBasicMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"basic-collection")) {
            return this.buildBasicCollectionMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"basic-map")) {
            return this.buildBasicMapMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"embedded")) {
            return this.buildEmbeddedMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"element-collection")) {
            return this.buildElementCollectionMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"many-to-many")) {
            return this.buildManyToManyMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"many-to-one")) {
            return this.buildManyToOneMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"one-to-many")) {
            return this.buildOneToManyMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"one-to-one")) {
            return this.buildOneToOneMapping();
        }
        if (ObjectTools.equals((Object)elementName, (Object)"transient")) {
            return this.buildTransientMapping();
        }
        return null;
    }

    final List<String> buildMappingElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("id");
        names.add("embedded-id");
        names.add("basic");
        names.add("basic-collection");
        names.add("basic-map");
        names.add("version");
        names.add("many-to-one");
        names.add("one-to-many");
        names.add("one-to-one");
        names.add("variable-one-to-one");
        names.add("many-to-many");
        names.add("element-collection");
        names.add("embedded");
        names.add("transformation");
        names.add("transient");
        names.add("structure");
        names.add("array");
        return names;
    }

    private List<ExternalMapping> buildMappings(Element element) {
        ArrayList<ExternalMapping> mappings = new ArrayList<ExternalMapping>();
        for (Element childElement : this.getChildren(element)) {
            String elementName = this.getNodeName(childElement);
            Mapping mapping = this.buildMapping(elementName);
            if (mapping == null) continue;
            mapping.calculateInsertionIndex(element, childElement, elementName);
            mappings.add(mapping);
        }
        return mappings;
    }

    private NoSql buildNoSql() {
        return new NoSql(this);
    }

    private ObjectTypeConverter buildObjectTypeConverter(int index) {
        return new ObjectTypeConverter(this, index);
    }

    private OneToManyMapping buildOneToManyMapping() {
        return new OneToManyMapping(this);
    }

    private OneToOneMapping buildOneToOneMapping() {
        return new OneToOneMapping(this);
    }

    private Property buildProperty(int index) {
        return new Property(this, index);
    }

    private StructConverter buildStructConverter(int index) {
        return new StructConverter(this, index);
    }

    private TransientMapping buildTransientMapping() {
        return new TransientMapping(this);
    }

    private TypeConverter buildTypeConverter(int index) {
        return new TypeConverter(this, index);
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public final List<ExternalClassConverter> converters() {
        int count = this.convertersSize();
        ArrayList<ExternalClassConverter> converters = new ArrayList<ExternalClassConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public final int convertersSize() {
        return this.getChildrenSize("converter");
    }

    @Override
    public final ExternalAccessMethods getAccessMethods() {
        if (this.hasChild("access-methods")) {
            return this.buildAccessMethods();
        }
        return null;
    }

    @Override
    public final AccessType getAccessType() {
        return this.getEnumAttribute("access", AccessType.class);
    }

    @Override
    public final TextRange getAccessTypeTextRange() {
        return this.getAttributeTextRange("access");
    }

    @Override
    public ExternalAssociationOverride getAssociationOverride(int index) {
        if (this.hasChild("association-override", index)) {
            return this.buildAssociationOverride(index);
        }
        return null;
    }

    @Override
    public ExternalAttributeOverride getAttributeOverride(int index) {
        if (this.hasChild("attribute-override", index)) {
            return this.buildAttributeOverride(index);
        }
        return null;
    }

    @Override
    public final ChangeTrackingType getChangeTrackingType() {
        return this.getChildEnumAttribute("change-tracking", "type", ChangeTrackingType.class);
    }

    @Override
    public final TextRange getChangeTrackingTypeTextRange() {
        return this.getChildAttributeTextRange("change-tracking", "type");
    }

    @Override
    public final String getClassName() {
        return this.getAttribute("class");
    }

    @Override
    public final TextRange getClassNameTextRange() {
        return this.getAttributeTextRange("class");
    }

    @Override
    public final String getClassShortName() {
        return NameTools.shortNameForClassNamed((String)this.getClassName());
    }

    @Override
    public final ExternalCloneCopyPolicy getCloneCopyPolicy() {
        if (this.hasChild("clone-copy-policy")) {
            return this.buildCloneCopyPolicy();
        }
        return null;
    }

    @Override
    public final ExternalClassConverter getConverter(int index) {
        if (this.hasChild("converter", index)) {
            return this.buildConverter(index);
        }
        return null;
    }

    @Override
    public final ExternalCopyPolicy getCopyPolicy() {
        if (this.hasChild("copy-policy")) {
            return this.buildCopyPolicy();
        }
        return null;
    }

    @Override
    public final String getCustomizerClassName() {
        return this.getChildAttribute("customizer", "class");
    }

    @Override
    public final TextRange getCustomizerClassNameTextRange() {
        return this.getChildAttributeTextRange("customizer", "class");
    }

    @Override
    public final String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    public final TextRange getDescriptionTextRange() {
        return this.getChildTextNodeTextRange("description");
    }

    @Override
    public final Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "embeddable";
    }

    @Override
    public TextRange getExcludeDefaultMappingsTextRange() {
        return this.getAttributeTextRange("exclude-default-mappings");
    }

    @Override
    @Deprecated
    public int getIndex() {
        return this.index;
    }

    @Override
    public final ExternalInstantiationCopyPolicy getInstantiationCopyPolicy() {
        if (this.hasChild("instantiation-copy-policy")) {
            return this.buildInstantiationCopyPolicy();
        }
        return null;
    }

    @Override
    public final Mapping getMapping(int index) {
        Element childElement;
        Element element = this.getChild("attributes");
        if (element != null && (childElement = this.getChild((Node)element, index)) != null) {
            String elementName = this.getNodeName(childElement);
            Mapping mapping = this.buildMapping(elementName);
            mapping.calculateInsertionIndex(element, childElement, elementName);
            return mapping;
        }
        return null;
    }

    @Override
    public final ExternalMapping getMapping(String name) {
        Element element = this.getChild("attributes");
        if (element != null) {
            for (Element mappingNode : this.getChildren(element)) {
                String mappingName = this.getAttribute(mappingNode, "name");
                if (!mappingName.equals(name)) continue;
                String elementName = this.getNodeName(mappingNode);
                Mapping mapping = this.buildMapping(elementName);
                mapping.calculateInsertionIndex(element, mappingNode, elementName);
                return mapping;
            }
        }
        return null;
    }

    protected List<String> getMappingElementNamesOrder() {
        return this.mappingElementNamesOrder;
    }

    @Override
    public final TextRange getMetadataCompleteTextRange() {
        return this.getAttributeTextRange("metadata-complete");
    }

    @Override
    public final ExternalNoSql getNoSql() {
        if (this.hasChild("no-sql")) {
            return this.buildNoSql();
        }
        return null;
    }

    @Override
    public final ExternalObjectTypeConverter getObjectTypeConverter(int index) {
        if (this.hasChild("object-type-converter", index)) {
            return this.buildObjectTypeConverter(index);
        }
        return null;
    }

    @Override
    public final String getParentClassName() {
        return this.getAttribute("parent-class");
    }

    @Override
    public TextRange getParentClassNameTextRange() {
        return this.getAttributeTextRange("parent-class");
    }

    @Override
    public final List<ExternalProperty> getProperties(String name) {
        ArrayList<ExternalProperty> properties = new ArrayList<ExternalProperty>();
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            properties.add(property);
        }
        return properties;
    }

    @Override
    public final ExternalProperty getProperty(int index) {
        if (this.hasChild("property", index)) {
            return this.buildProperty(index);
        }
        return null;
    }

    @Override
    public final ExternalProperty getProperty(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public final ExternalProperty getProperty(String name, int index) {
        ExternalProperty property = this.getProperty(index);
        if (property != null && ObjectTools.equals((Object)name, (Object)property.getName())) {
            return property;
        }
        return null;
    }

    @Override
    public final ExternalProperty getProperty(String name, String value) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name) || !ObjectTools.equals((Object)property.getValue(), (Object)value)) continue;
            return property;
        }
        return null;
    }

    @Override
    public final TextRange getPropertyNameTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getNameTextRange();
        }
        return null;
    }

    @Override
    public final TextRange getPropertyTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getTextRange();
        }
        return null;
    }

    @Override
    public final TextRange getPropertyTextRange(String name, String value) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name) || !ObjectTools.equals((Object)property.getValue(), (Object)value)) continue;
            return property.getTextRange();
        }
        return null;
    }

    @Override
    public final TextRange getPropertyValueTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getValueTextRange();
        }
        return null;
    }

    @Override
    public final ExternalStructConverter getStructConverter(int index) {
        if (this.hasChild("struct-converter", index)) {
            return this.buildStructConverter(index);
        }
        return null;
    }

    @Override
    public final ExternalTypeConverter getTypeConverter(int index) {
        if (this.hasChild("type-converter", index)) {
            return this.buildTypeConverter(index);
        }
        return null;
    }

    @Override
    public final boolean hasAccessMethods() {
        return this.hasChild("access-methods");
    }

    @Override
    public final boolean hasCloneCopyPolicy() {
        return this.hasChild("clone-copy-policy");
    }

    @Override
    public final boolean hasCopyPolicy() {
        return this.hasChild("copy-policy");
    }

    @Override
    public final boolean hasInstantiationCopyPolicy() {
        return this.hasChild("instantiation-copy-policy");
    }

    @Override
    public final boolean hasNoSql() {
        return this.hasChild("no-sql");
    }

    @Override
    public final List<ExternalIDMapping> idMappings() {
        ArrayList<ExternalIDMapping> idMappings = new ArrayList<ExternalIDMapping>();
        for (ExternalMapping mapping : this.mappings()) {
            if (!(mapping instanceof ExternalIDMapping)) continue;
            idMappings.add((ExternalIDMapping)mapping);
        }
        return idMappings;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.mappingElementNamesOrder = this.buildMappingElementNamesOrder();
    }

    @Override
    public final Boolean isExcludeDefaultMappings() {
        return this.getBooleanAttribute("exclude-default-mappings");
    }

    @Override
    public final Boolean isMetadataComplete() {
        return this.getBooleanAttribute("metadata-complete");
    }

    @Override
    public final List<ExternalMapping> mappings() {
        Element element = this.getChild("attributes");
        if (element != null) {
            return this.buildMappings(element);
        }
        return Collections.emptyList();
    }

    @Override
    public final int mappingsSize() {
        Element attributes = this.getChild("attributes");
        if (attributes != null) {
            return this.getChildrenSize((Node)attributes, this.getMappingElementNamesOrder());
        }
        return 0;
    }

    @Override
    public final List<ExternalObjectTypeConverter> objectTypeConverters() {
        int count = this.objectTypeConvertersSize();
        ArrayList<ExternalObjectTypeConverter> converters = new ArrayList<ExternalObjectTypeConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildObjectTypeConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public final int objectTypeConvertersSize() {
        return this.getChildrenSize("object-type-converter");
    }

    @Override
    public final List<ExternalProperty> properties() {
        int count = this.propertiesSize();
        ArrayList<ExternalProperty> properties = new ArrayList<ExternalProperty>(count);
        int index = 0;
        while (index < count) {
            properties.add(this.buildProperty(index));
            ++index;
        }
        return properties;
    }

    @Override
    public final int propertiesSize() {
        return this.getChildrenSize("property");
    }

    @Override
    public final int propertiesSize(String name) {
        int count = 0;
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final void removeAccessMethods() {
        this.removeChild("access-methods");
    }

    @Override
    public void removeAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.removeSelf();
    }

    @Override
    public void removeAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(index);
        attributeOverride.removeSelf();
    }

    @Override
    public final void removeCloneCopyPolicy() {
        CloneCopyPolicy policy = this.buildCloneCopyPolicy();
        policy.removeSelf();
    }

    @Override
    public final void removeConverter(int index) {
        ClassConverter converter = this.buildConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void removeCopyPolicy() {
        CopyPolicy policy = this.buildCopyPolicy();
        policy.removeSelf();
    }

    @Override
    public final void removeInstantiationCopyPolicy() {
        InstantiationCopyPolicy policy = this.buildInstantiationCopyPolicy();
        policy.removeSelf();
    }

    @Override
    public final void removeMapping(int index) {
        Mapping mapping = this.getMapping(index);
        if (mapping != null) {
            mapping.removeSelf();
        }
    }

    @Override
    public final void removeMapping(String name) {
        Element element = this.getChild("attributes");
        if (element != null) {
            for (Element mappingNode : this.getChildren(element)) {
                String mappingName = this.getAttribute(mappingNode, "name");
                if (!mappingName.equals(name)) continue;
                this.remove(element, mappingNode);
                break;
            }
        }
    }

    @Override
    public final void removeNoSql() {
        NoSql noSql = this.buildNoSql();
        noSql.removeSelf();
    }

    @Override
    public final void removeObjectTypeConverter(int index) {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void removeProperty(int index) {
        Property converter = this.buildProperty(index);
        converter.removeSelf();
    }

    @Override
    public final void removeProperty(String name) {
        Property property = (Property)this.getProperty(name);
        property.removeSelf();
    }

    @Override
    public final void removeProperty(String name, String value) {
        Property property = (Property)this.getProperty(name, value);
        property.removeSelf();
    }

    @Override
    public final void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public final void removeStructConverter(int index) {
        StructConverter converter = this.buildStructConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void removeTypeConverter(int index) {
        TypeConverter converter = this.buildTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void setAccessType(AccessType type) {
        this.setAttribute("access", type);
    }

    @Override
    public final void setChangeTrackingType(ChangeTrackingType type) {
        this.updateChildAttribute("change-tracking", "type", (Enum<?>)type);
    }

    @Override
    public final void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @Override
    public final void setCustomizerClassName(String name) {
        this.updateChildAttribute("customizer", "class", name);
    }

    @Override
    public final void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public final void setExcludeDefaultMappings(Boolean excludeDefaultMappings) {
        this.setAttribute("exclude-default-mappings", excludeDefaultMappings);
    }

    @Override
    public final void setMetadataComplete(Boolean metaDataComplete) {
        this.setAttribute("metadata-complete", metaDataComplete);
    }

    @Override
    public final void setParentClassName(String className) {
        this.setAttribute("parent-class", className);
    }

    @Override
    public final List<ExternalStructConverter> structConverters() {
        int count = this.structConvertersSize();
        ArrayList<ExternalStructConverter> converters = new ArrayList<ExternalStructConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildStructConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public final int structConvertersSize() {
        return this.getChildrenSize("struct-converter");
    }

    @Override
    public final List<ExternalTypeConverter> typeConverters() {
        int count = this.typeConvertersSize();
        ArrayList<ExternalTypeConverter> converters = new ArrayList<ExternalTypeConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildTypeConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public final int typeConvertersSize() {
        return this.getChildrenSize("type-converter");
    }
}

