/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.AssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;

final class EmbeddedMapping
extends NonTransientMapping
implements ExternalEmbeddedMapping {
    EmbeddedMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalAssociationOverride addAssociationOverride() {
        AssociationOverride associationOverride = this.buildAssociationOverride(-1);
        associationOverride.addSelf();
        return associationOverride;
    }

    @Override
    public ExternalAttributeOverride addAttributeOverride() {
        AttributeOverride attributeOverride = this.buildAttributeOverride(-1);
        attributeOverride.addSelf();
        return attributeOverride;
    }

    @Override
    public List<ExternalAssociationOverride> associationOverrides() {
        int count = this.associationOverridesSize();
        ArrayList<ExternalAssociationOverride> associationOverrides = new ArrayList<ExternalAssociationOverride>(count);
        int index = 0;
        while (index < count) {
            associationOverrides.add(this.buildAssociationOverride(index));
            ++index;
        }
        return associationOverrides;
    }

    @Override
    public int associationOverridesSize() {
        return this.getChildrenSize("association-override");
    }

    @Override
    public List<ExternalAttributeOverride> attributeOverrides() {
        int count = this.attributeOverridesSize();
        ArrayList<ExternalAttributeOverride> attributeOverrides = new ArrayList<ExternalAttributeOverride>(count);
        int index = 0;
        while (index < count) {
            attributeOverrides.add(this.buildAttributeOverride(index));
            ++index;
        }
        return attributeOverrides;
    }

    @Override
    public int attributeOverridesSize() {
        return this.getChildrenSize("attribute-override");
    }

    private AssociationOverride buildAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("access");
        names.add("attribute-type");
        return names;
    }

    private AttributeOverride buildAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("attribute-override");
        names.add("association-override");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private ExternalNoSqlField buildNoSqlField() {
        return new NoSqlField(this);
    }

    @Override
    public ExternalAssociationOverride getAssociationOverride(int index) {
        if (this.hasChild("association-override", index)) {
            return this.buildAssociationOverride(index);
        }
        return null;
    }

    @Override
    public ExternalAttributeOverride getAttributeOverride(int index) {
        if (this.hasChild("attribute-override", index)) {
            return this.buildAttributeOverride(index);
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return "embedded";
    }

    @Override
    public String getNoSqlField() {
        ExternalNoSqlField field = this.buildNoSqlField();
        return field.getName();
    }

    @Override
    public boolean isEmbeddedMapping() {
        return true;
    }

    @Override
    public void removeAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.removeSelf();
    }

    @Override
    public void removeAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(index);
        attributeOverride.removeSelf();
    }

    @Override
    public void setNoSqlField(String field) {
        ExternalNoSqlField noSqlField = this.buildNoSqlField();
        noSqlField.setName(field);
    }
}

