/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectCollectionMapping;
import org.eclipse.persistence.tools.utility.TextRange;

final class OneToManyMapping
extends ObjectCollectionMapping
implements ExternalOneToManyMapping {
    OneToManyMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalJoinColumn addJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn("join-column", -1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    public ExternalNoSqlJoinField addJoinField(String name) {
        NoSqlJoinField joinField = this.buildJoinField(-1);
        joinField.addSelf();
        joinField.setName(name);
        return joinField;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("access");
        names.add("mapped-by-id");
        names.add("maps-id");
        names.add("orphan-removal");
        names.add("attribute-type");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("order-by");
        names.add("order-column");
        names.add("map-key");
        names.add("map-key-class");
        names.add("map-key-temporal");
        names.add("map-key-enumerated");
        names.add("map-key-convert");
        names.add("map-key-attribute-override");
        names.add("map-key-association-override");
        names.add("map-key-column");
        names.add("map-key-join-column");
        names.add("join-table");
        names.add("join-column");
        names.add("cascade");
        names.add("private-owned");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private NoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    @Override
    protected String getElementName() {
        return "one-to-many";
    }

    @Override
    public Boolean getId() {
        return null;
    }

    @Override
    public TextRange getIdTextRange() {
        return this.getElementNameTextRange(this.getElement());
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        if (this.hasChild("join-column", index)) {
            return this.buildJoinColumn("join-column", index);
        }
        return null;
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute("mapped-by-id");
    }

    @Override
    public TextRange getMappedByMappingNameTextRange() {
        return this.getAttributeTextRange("mapped-by-id");
    }

    @Override
    public String getMapsId() {
        return this.getAttribute("maps-id");
    }

    @Override
    public TextRange getMapsIdTextRange() {
        return this.getAttributeTextRange("maps-id");
    }

    @Override
    public TextRange getOrphanRemovalTextRange() {
        return this.getAttributeTextRange("orphan-removal");
    }

    @Override
    public TextRange getPrivateOwnedTextRange() {
        return this.getChildTextRange("private-owned");
    }

    @Override
    public Boolean isOrphanRemoval() {
        return this.getBooleanAttribute("orphan-removal");
    }

    @Override
    public Boolean isPrivateOwned() {
        return this.hasChild("private-owned");
    }

    @Override
    public List<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn("join-column", index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public List<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = 0;
        while (index < count) {
            joinFields.add(this.buildJoinField(index));
            ++index;
        }
        return joinFields;
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn("join-column", index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void setId(Boolean id) {
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute("mapped-by-id", name);
    }

    @Override
    public void setMapsId(String mapsId) {
        this.setAttribute("maps-id", mapsId);
    }

    @Override
    public void setOrphanRemoval(Boolean removeOrphans) {
        this.setAttribute("orphan-removal", removeOrphans);
    }

    @Override
    public void setPrivateOwned(Boolean privateOwned) {
        if (privateOwned == Boolean.TRUE) {
            this.addChild("private-owned");
        } else {
            this.removeChild("private-owned");
        }
    }
}

