/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.tools.db.relational.ELColumn;
import org.eclipse.persistence.tools.db.relational.ELDatabase;
import org.eclipse.persistence.tools.db.relational.ELModel;
import org.eclipse.persistence.tools.db.relational.ELReference;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.db.relational.spi.ExternalColumn;
import org.eclipse.persistence.tools.db.relational.spi.ExternalForeignKey;
import org.eclipse.persistence.tools.db.relational.spi.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.db.relational.spi.ExternalTable;
import org.eclipse.persistence.tools.db.relational.spi.ExternalTableDescription;
import org.eclipse.persistence.tools.utility.NameTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneIterable;
import org.eclipse.persistence.tools.utility.iterator.CompositeIterator;
import org.eclipse.persistence.tools.utility.iterator.FilteringIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;
import org.eclipse.persistence.tools.utility.node.Node;

public final class ELTable
extends ELModel {
    private volatile String catalog;
    public static final String CATALOG_PROPERTY = "catalog";
    private volatile String schema;
    public static final String SCHEMA_PROPERTY = "schema";
    private volatile String shortName;
    public static final String SHORT_NAME_PROPERTY = "shortName";
    public static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private Date lastRefreshTimestamp;
    public static final String LAST_REFRESH_TIMESTAMP_PROPERTY = "lastRefreshTimestamp";
    private Collection<ELColumn> columns;
    public static final String COLUMNS_COLLECTION = "columns";
    private Collection<ELReference> references;
    public static final String REFERENCES_COLLECTION = "references";
    private boolean legacyIsFullyQualified;

    ELTable(ELDatabase database, String catalog, String schema, String shortName) {
        super(database);
        this.catalog = catalog;
        this.schema = schema;
        this.shortName = shortName;
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.lastRefreshTimestamp = null;
        this.columns = new Vector<ELColumn>();
        this.references = new Vector<ELReference>();
    }

    public String getCatalog() {
        return this.catalog;
    }

    private void setCatalog(String catalog) {
        String old = this.catalog;
        this.catalog = catalog;
        if (this.attributeValueHasChanged(old, catalog)) {
            this.firePropertyChanged(CATALOG_PROPERTY, old, catalog);
            this.qualifiedNameChanged();
        }
    }

    public String getSchema() {
        return this.schema;
    }

    private void setSchema(String schema) {
        String old = this.schema;
        this.schema = schema;
        if (this.attributeValueHasChanged(old, schema)) {
            this.firePropertyChanged(SCHEMA_PROPERTY, old, schema);
            this.qualifiedNameChanged();
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    private void setShortName(String shortName) {
        String old = this.shortName;
        this.shortName = shortName;
        if (this.attributeValueHasChanged(old, shortName)) {
            this.firePropertyChanged(SHORT_NAME_PROPERTY, old, shortName);
            this.qualifiedNameChanged();
        }
    }

    private void qualifiedNameChanged() {
        this.firePropertyChanged(QUALIFIED_NAME_PROPERTY, this.qualifiedName());
        this.getParent().nodeRenamed(this);
        for (ELColumn column : this.columns()) {
            column.qualifiedNameChanged();
        }
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    private void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        Date old = this.lastRefreshTimestamp;
        this.lastRefreshTimestamp = lastRefreshTimestamp;
        this.firePropertyChanged(LAST_REFRESH_TIMESTAMP_PROPERTY, old, lastRefreshTimestamp);
    }

    public Iterable<ELColumn> columns() {
        return new LiveCloneIterable<ELColumn>(this.columns){

            protected void remove(ELColumn current) {
                ELTable.this.removeColumn(current);
            }
        };
    }

    public int columnsSize() {
        return this.columns.size();
    }

    public ELColumn addColumn(String name) {
        this.checkColumnName(name);
        return this.addColumn(new ELColumn(this, name));
    }

    private ELColumn addColumn(ELColumn column) {
        this.addItemToCollection(column, this.columns, COLUMNS_COLLECTION);
        return column;
    }

    public void removeColumn(ELColumn column) {
        this.removeNodeFromCollection(column, this.columns, COLUMNS_COLLECTION);
    }

    public void removeColumns(Iterator<ELColumn> cols) {
        while (cols.hasNext()) {
            this.removeColumn(cols.next());
        }
    }

    public void removeColumns(Collection<ELColumn> cols) {
        this.removeColumns(cols.iterator());
    }

    public boolean containsColumnNamed(String columnName) {
        return this.columnNamed(columnName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELColumn columnNamed(String unqualifiedColumnName) {
        Collection<ELColumn> collection = this.columns;
        synchronized (collection) {
            for (ELColumn column : this.columns) {
                if (!column.getName().equals(unqualifiedColumnName)) continue;
                return column;
            }
        }
        return null;
    }

    public ELColumn columnWithQualifiedName(String name) {
        if (!ELColumn.parseTableNameFromQualifiedName(name).equals(this.getName())) {
            throw new IllegalArgumentException();
        }
        return this.columnNamed(ELColumn.parseColumnNameFromQualifiedName(name));
    }

    public Iterator<String> columnNames() {
        return new TransformationIterator<ELColumn, String>(this.columns()){

            protected String transform(ELColumn next) {
                return next.getName();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int primaryKeyColumnsSize() {
        int size = 0;
        Collection<ELColumn> collection = this.columns;
        synchronized (collection) {
            for (ELColumn column : this.columns) {
                if (!column.isPrimaryKey()) continue;
                ++size;
            }
        }
        return size;
    }

    public Iterator<ELColumn> primaryKeyColumns() {
        return new FilteringIterator<ELColumn>(this.columns()){

            protected boolean accept(ELColumn o) {
                return o.isPrimaryKey();
            }
        };
    }

    public Iterator<String> primaryKeyColumnNames() {
        return new TransformationIterator<ELColumn, String>(this.primaryKeyColumns()){

            protected String transform(ELColumn next) {
                return next.getName();
            }
        };
    }

    public Iterator<ELColumn> nonPrimaryKeyColumns() {
        return new FilteringIterator<ELColumn>(this.columns()){

            protected boolean accept(ELColumn o) {
                return !o.isPrimaryKey();
            }
        };
    }

    public ELColumn addColumnLike(ELColumn original) {
        ELColumn copy = this.addColumn(original.getName());
        copy.copySettingsFrom(original);
        return copy;
    }

    public Iterable<ELReference> references() {
        return new LiveCloneIterable<ELReference>(this.references){

            protected void remove(ELReference current) {
                ELTable.this.removeReference(current);
            }
        };
    }

    public int referencesSize() {
        return this.references.size();
    }

    public ELReference addReference(String name, ELTable targetTable) {
        this.checkReferenceName(name);
        return this.addReference(new ELReference(this, name, targetTable));
    }

    private ELReference addReference(ELReference reference) {
        this.addItemToCollection(reference, this.references, REFERENCES_COLLECTION);
        return reference;
    }

    public void removeReference(ELReference reference) {
        this.removeNodeFromCollection(reference, this.references, REFERENCES_COLLECTION);
    }

    public void removeReferences(Iterator<ELReference> refs) {
        while (refs.hasNext()) {
            this.removeReference(refs.next());
        }
    }

    public void removeReferences(Collection<ELReference> refs) {
        this.removeReferences(refs.iterator());
    }

    private void removeDatabaseReferences(Iterator<ELReference> refs) {
        while (refs.hasNext()) {
            ELReference ref = refs.next();
            if (!ref.isOnDatabase()) continue;
            this.removeReference(ref);
        }
    }

    private void removeDatabaseReferences(Collection<ELReference> refs) {
        this.removeDatabaseReferences(refs.iterator());
    }

    public boolean containsReferenceNamed(String referenceName) {
        return this.referenceNamed(referenceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELReference referenceNamed(String referenceName) {
        Collection<ELReference> collection = this.references;
        synchronized (collection) {
            for (ELReference reference : this.references) {
                if (!reference.getName().equals(referenceName)) continue;
                return reference;
            }
            return null;
        }
    }

    public Iterator<String> referenceNames() {
        return new TransformationIterator<ELReference, String>(this.references()){

            protected String transform(ELReference next) {
                return next.getName();
            }
        };
    }

    public Iterator<ELReference> databaseReferences() {
        return new FilteringIterator<ELReference>(this.references()){

            protected boolean accept(ELReference o) {
                return o.isOnDatabase();
            }
        };
    }

    public Iterator<ELReference> referencesBetween(ELTable table) {
        return new CompositeIterator(new Iterator[]{this.referencesTo(table), table.referencesTo(this)});
    }

    public Iterator<ELReference> referencesTo(final ELTable targetTable) {
        return new FilteringIterator<ELReference>(this.references()){

            protected boolean accept(ELReference o) {
                return o.getTargetTable() == targetTable;
            }
        };
    }

    public String getName() {
        return this.qualifiedName();
    }

    public DatabasePlatform databasePlatform() {
        return this.getParent().getDatabasePlatform();
    }

    boolean nameMatches(String cat, String sch, String sn) {
        return this.valuesAreEqual(this.catalog, cat) && this.valuesAreEqual(this.schema, sch) && this.valuesAreEqual(this.shortName, sn);
    }

    boolean nameMatchesIgnoreCase(String cat, String sch, String sn) {
        return StringTools.equalsIgnoreCase((String)this.catalog, (String)cat) && StringTools.equalsIgnoreCase((String)this.schema, (String)sch) && StringTools.equalsIgnoreCase((String)this.shortName, (String)sn);
    }

    public boolean nameIsQualified() {
        if (this.catalog != null) {
            return true;
        }
        return this.schema != null;
    }

    public boolean nameIsUnqualified() {
        return !this.nameIsQualified();
    }

    public String qualifiedName() {
        return NameTools.buildQualifiedName((String[])new String[]{this.catalog, this.schema, this.shortName});
    }

    public String unqualifiedName() {
        return this.shortName;
    }

    private String qualifier() {
        if (this.nameIsUnqualified()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(100);
        if (this.catalog != null) {
            sb.append(this.catalog);
        }
        if (this.schema != null) {
            if (this.catalog != null) {
                sb.append('.');
            }
            sb.append(this.schema);
        }
        return sb.toString();
    }

    public ELDatabase getParent() {
        return (ELDatabase)super.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List<Node> children) {
        super.addChildrenTo(children);
        Collection<ELModel> collection = this.columns;
        synchronized (collection) {
            children.addAll(this.columns);
        }
        collection = this.references;
        synchronized (collection) {
            children.addAll(this.references);
        }
    }

    public void rename(String newCatalog, String newSchema, String newShortName) {
        if (this.nameMatches(newCatalog, newSchema, newShortName)) {
            return;
        }
        this.getParent().checkTableName(newCatalog, newSchema, newShortName, this);
        this.setCatalog(newCatalog);
        this.setSchema(newSchema);
        this.setShortName(newShortName);
    }

    void checkColumnName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsColumnNamed(columnName)) {
            throw new IllegalArgumentException("duplicate column name: " + columnName);
        }
    }

    void checkReferenceName(String referenceName) {
        if (referenceName == null || referenceName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsReferenceNamed(referenceName)) {
            throw new IllegalArgumentException("duplicate reference name: " + referenceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void databasePlatformChanged() {
        Collection<ELColumn> collection = this.columns;
        synchronized (collection) {
            Iterator<ELColumn> stream = this.columns.iterator();
            while (stream.hasNext()) {
                stream.next().databasePlatformChanged();
            }
        }
    }

    public Iterator<ExternalTableDescription> matchingExternalTableDescriptions() {
        return this.getParent().externalTableDescriptions(this.catalog, this.schema, this.shortName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumns(ExternalTable externalTable) {
        HashSet<ELColumn> removedColumns;
        Collection<ELColumn> collection = this.columns;
        synchronized (collection) {
            removedColumns = new HashSet<ELColumn>(this.columns);
        }
        ExternalColumn[] externalColumns = externalTable.getColumns();
        int i = externalColumns.length;
        while (i-- > 0) {
            this.refreshColumn(externalColumns[i], removedColumns);
        }
        this.removeColumns(removedColumns);
        this.setLastRefreshTimestamp(new Date());
    }

    private void refreshColumn(ExternalColumn externalColumn, Collection<ELColumn> removedColumns) {
        ELColumn existingColumn = this.columnNamed(externalColumn.getName());
        if (existingColumn == null) {
            existingColumn = this.addColumn(externalColumn.getName());
        } else {
            removedColumns.remove(existingColumn);
        }
        existingColumn.refresh(externalColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshReferences(ExternalTable externalTable) {
        HashSet<ELReference> removedReferences;
        Collection<ELReference> collection = this.references;
        synchronized (collection) {
            removedReferences = new HashSet<ELReference>(this.references);
        }
        ExternalForeignKey[] externalForeignKeys = externalTable.getForeignKeys();
        int i = externalForeignKeys.length;
        while (i-- > 0) {
            this.refreshReference(externalForeignKeys[i], removedReferences);
        }
        this.removeDatabaseReferences(removedReferences);
    }

    private void refreshReference(ExternalForeignKey externalForeignKey, Collection<ELReference> removedReferences) {
        ExternalTableDescription ttd = externalForeignKey.getTargetTableDescription();
        ELTable targetTable = this.getParent().tableNamed(ttd.getCatalogName(), ttd.getSchemaName(), ttd.getName());
        if (targetTable == null) {
            targetTable = this.getParent().tableNamed(null, null, ttd.getName());
        }
        if (targetTable == null) {
            return;
        }
        for (ELReference ref : removedReferences) {
            if (!ref.getName().equals(externalForeignKey.getName())) continue;
            ref.setTargetTable(targetTable);
            ref.refreshColumnPairs(externalForeignKey);
            ref.setOnDatabase(true);
            removedReferences.remove(ref);
            return;
        }
        for (ELReference ref : removedReferences) {
            if (!ref.matchesColumnPairs(externalForeignKey)) continue;
            ref.setName(externalForeignKey.getName());
            ref.setTargetTable(targetTable);
            ref.setOnDatabase(true);
            removedReferences.remove(ref);
            return;
        }
        ELReference ref = this.addReference(externalForeignKey.getName(), targetTable);
        ExternalForeignKeyColumnPair[] pairs = externalForeignKey.getColumnPairs();
        int i = pairs.length;
        while (i-- > 0) {
            ref.addColumnPair(this.column(pairs[i].getSourceColumn()), targetTable.column(pairs[i].getTargetColumn()));
        }
        ref.setOnDatabase(true);
    }

    ELColumn column(ExternalColumn externalColumn) {
        return externalColumn == null ? null : this.columnNamed(externalColumn.getName());
    }

    public void toString(StringBuffer sb) {
        sb.append(this.qualifiedName());
    }

    @Override
    public String displayString() {
        return this.qualifiedName();
    }
}

