/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for an fetch group.
 * One or more fetch groups can be declared as part of an entity
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.FetchGroup
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalFetchGroup extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String FETCH_GROUP = "fetch-group";

	/**
	 * The attribute name used to store and retrieve the load property.
	 */
	String LOAD = "load";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * Returns whether this fetch group loads.
	 */
	Boolean doesLoad();

	/**
	 * Returns the {@link TextRange} for the this fetch group loads value.
	 */
	TextRange getDoesLoadTextRange();

	/**
	 * Returns the name of fetch group.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name of fetch group.
	 */
	TextRange getNameTextRange();

	/**
	 * Sets the name for the fetch group.
	 */
	void setName(String name);

	/**
	 * Sets whether this fetch group should load.
	 */
	void setShouldLoad(Boolean load);
}