/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for an tenant
 * discriminator column. One or more columns can be declared on a Multitenant
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.TenantDiscriminatorColumn
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalTenantDiscriminatorColumn extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the column-definition property.
	 */
	String COLUMN_DEFINITION = "column-definition";

	/**
	 * The attribute name used to store and retrieve the context-property property.
	 */
	String CONTEXT_PROPERTY = "context-property";

	/**
	 * The attribute name used to store and retrieve the discriminator-type property.
	 */
	String DISCRIMINATOR_TYPE = "discriminator-type";

	/**
	 * The attribute name used to store and retrieve the length property.
	 */
	String LENGTH = "length";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the primary-key property.
	 */
	String PRIMARY_KEY = "primary-key";

	/**
	 * The attribute name used to store and retrieve the table property.
	 */
	String TABLE = "table";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String TENANT_DISCRIMINATOR_COLUMN = "tenant-discriminator-column";

	/**
	 * Returns the SQL definition of the column.
	 */
	String getColumnDefinition();

	/**
	 * Returns the {@link TextRange} for the column definition of the column.
	 */
	TextRange getColumnDefinitionTextRange();

	/**
	 * Returns the text range of of the column.
	 */
	TextRange getColumnTextRange();

	/**
	 * Returns the context property of the column.
	 */
	String getContextProperty();

	/**
	 * Returns the {@link TextRange} for the context property of the column.
	 */
	TextRange getContextPropertyTextRange();

	/**
	 * Type of the discriminator column.
	 */
	DiscriminatorType getDiscriminatorType();

	/**
	 * Returns the {@link TextRange} for the discriminator type of the column.
	 */
	TextRange getDiscriminatorTypeTextRange();

	@Deprecated
	int getIndex();

	/**
	 * Returns the length of the column.
	 */
	Integer getLength();

	/**
	 * Returns the {@link TextRange} for the length of the column.
	 */
	TextRange getLengthTextRange();

	/**
	 * Name of the discriminator column.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name of the column.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the {@link TextRange} for the primary key of the column.
	 */
	TextRange getPrimaryKeyTextRange();

	/**
	 * Returns the table name that this column exists in
	 */
	String getTableName();

	/**
	 * Returns the {@link TextRange} for the table name of the column.
	 */
	TextRange getTableNameTextRange();

	/**
	 * Returns whether this column is part of the primary key
	 */
	Boolean isPrimaryKey();

	/**
	 * Set the column definition.
	 */
	void setColumnDefinition(String definition);

	/**
	 * Set the context property for the column.
	 */
	void setContextProperty(String contextProperty);

	/**
	 * Set the discriminator type.
	 */
	void setDiscriminatorType(DiscriminatorType type);

	/**
	 * Set the length.
	 */
	void setLength(Integer length);

	/**
	 * Sets the name of the column.
	 */
	void setName(String name);

	/**
	 * Sets whether this column is part of the primary key
	 */
	void setPrimaryKey(Boolean primaryKey);

	/**
	 * Sets the table name in which this column exists
	 */
	void setTableName(String tableName);
}
