/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * Describes the properties of a Version mapping defined in the ORM.xml. A Version mapping may be
 * defined in the "attributes" section of an Entity or MappedSuperClass.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html,persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalVersionMapping extends ExternalColumnMapping {

	/**
	 * The attribute name used to store and retrieve the mutable property.
	 */
	String MUTABLE = "mutable";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String VERSION = "version";

	/**
	 * Visits this {@link ExternalVersionMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Returns the {@link TextRange} for the mutable value.
	 */
	TextRange getMutableTextRange();

	/**
	 * Returns whether the mapping is mutable.
	 */
	Boolean isMutable();

	/**
	 * Sets whether the mapping is mutable.
	 */
	void setMutable(Boolean mutable);
}