/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

/**
 * The external form of the tenant discriminator column.
 *
 * @see MultitenancyPolicy
 *
 * @version 2.6
 */
abstract class AbstractTenantDiscriminatorColumn extends AbstractExternalForm
                                                 implements ExternalTenantDiscriminatorColumn {

	/**
	 * The index of this column
	 */
	private int index;

	/**
	 * Creates a new <code>AbstractTenantDiscriminatorColumn</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the external form of the mapping in the list of children
	 */
	public AbstractTenantDiscriminatorColumn(AbstractExternalForm parent, int index) {
		super(parent);
		this.index = index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
		if (elementName == getElementName()) {
			index = index(parent, child, elementName);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getColumnDefinition() {
		return getAttribute(COLUMN_DEFINITION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getColumnDefinitionTextRange() {
		return getAttributeTextRange(COLUMN_DEFINITION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getColumnTextRange() {
		return getTextNodeTextRange(getElement());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getContextProperty() {
		return getAttribute(CONTEXT_PROPERTY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getContextPropertyTextRange() {
		return getAttributeTextRange(CONTEXT_PROPERTY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DiscriminatorType getDiscriminatorType() {
		return getEnumAttribute(DISCRIMINATOR_TYPE, DiscriminatorType.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getDiscriminatorTypeTextRange() {
		return getAttributeTextRange(DISCRIMINATOR_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return TENANT_DISCRIMINATOR_COLUMN;
	}

	@Override
	@Deprecated
	// TODO: Change visibility to default once it's no longer on the interface
	public int getIndex() {
		return index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getLength() {
		return getIntegerAttribute(LENGTH);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getLengthTextRange() {
		return getAttributeTextRange(LENGTH);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getNameTextRange() {
		return getAttributeTextRange(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getPrimaryKeyTextRange() {
		return getAttributeTextRange(PRIMARY_KEY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getTableName() {
		return getAttribute(TABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getTableNameTextRange() {
		return getAttributeTextRange(TABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean isPrimaryKey() {
		return getBooleanAttribute(PRIMARY_KEY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setColumnDefinition(String definition) {

		setAttribute(COLUMN_DEFINITION, definition);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setContextProperty(String contextProperty) {

		setAttribute(CONTEXT_PROPERTY, contextProperty);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDiscriminatorType(DiscriminatorType type) {

		setAttribute(DISCRIMINATOR_TYPE, type);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLength(Integer length) {

		setAttribute(LENGTH, length);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {

		setAttribute(NAME, name);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPrimaryKey(Boolean primaryKey) {

		setAttribute(PRIMARY_KEY, primaryKey);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTableName(String tableName) {

		setAttribute(TABLE, tableName);

		if (!hasAnything()) {
			removeSelf();
		}
	}
}