/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransformer;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a transformer.
 *
 * @version 2.6
 */
abstract class Transformer extends AbstractExternalForm
                           implements ExternalTransformer {

	/**
	 * Creates a new <code>Transformer</code>.
	 *
	 * @param parent The parent of this external form
	 */
	Transformer(AbstractExternalForm parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(TRANSFORMER_CLASS);
		names.add(METHOD);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String getMethodName() {
		return getAttribute(METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final TextRange getMethodNameTextRange() {
		return getAttributeTextRange(METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String getTransfomerClassName() {
		return getAttribute(TRANSFORMER_CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final TextRange getTransfomerClassNameTextRange() {
		return getAttributeTextRange(TRANSFORMER_CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setMethodName(String name) {
		setAttribute(METHOD, name);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setTransformerClassName(String name) {
		setAttribute(TRANSFORMER_CLASS, name);
	}
}