/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

import org.eclipse.persistence.tools.gen.db.Database;

/**
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
class MaxDB extends AbstractWorkbenchDriverAdapter {
	MaxDB(Database database) {
		super(database);
	}

	@Override
	CatalogStrategy buildCatalogStrategy() {
		// unverified...
	//	return new UnknownCatalogStrategy(this.database.getDTPDatabase());
		throw new UnsupportedOperationException("Max DB not yet supported!");
	}

	@Override
	FoldingStrategy buildFoldingStrategy() {
		return UpperCaseFoldingStrategy.instance();
	}

	@Override
	char[] getExtendedRegularNameStartCharacters() {
		return EXTENDED_REGULAR_NAME_START_CHARACTERS;
	}
	private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[] { '#', '@', '$' };

	// ********** factory **********

	static class Factory implements WorkbenchDriverAdapterFactory {
		private static final String[] VENDORS = {
			"MaxDB"
		};
		@Override
		public String[] getSupportedVendors() {
			return VENDORS;
		}
		@Override
		public WorkbenchDriverAdapter buildAdapter(Database database) {
			return new MaxDB(database);
		}
	}
}