/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

/**
 * Do not fold <em>regular</em> identifiers.
 *
 * @version 2.6
 */
class NonFoldingStrategy implements FoldingStrategy {

	// singleton
	private static final FoldingStrategy INSTANCE = new NonFoldingStrategy();

	/**
	 * Returns the singleton.
	 */
	static FoldingStrategy instance() {
		return INSTANCE;
	}

	/**
	 * Ensure single instance.
	 */
	private NonFoldingStrategy() {
		super();
	}

	/**
	 * Since identifiers are not folded to upper- or lower-case, the name is
	 * already <em>folded</em>.
	 */
	@Override
	public String fold(String identifier) {
		return identifier;
	}

	/**
	 * Since identifiers are not folded to upper- or lower-case, the name is
	 * already <em>folded</em>.
	 * (Non-folding databases do not require delimiters around mixed-case
	 * <em>regular</em> identifiers.)
	 */
	@Override
	public boolean nameIsFolded(String name) {
		return true;
	}

	@Override
	public String toString() {
		return this.getClass().getSimpleName();
	}
}