/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterable.SingleElementListIterable;

@SuppressWarnings("nls")
public class SingleElementListIterableTests extends TestCase {

	public SingleElementListIterableTests(String name) {
		super(name);
	}

	public void testIterator() {
		for (String s : this.buildSingleElementListIterable()) {
			assertEquals(this.singleElement(), s);
		}
	}

	public void testNoSuchElementException() {
		boolean exCaught = false;
		Iterator<String> stream = this.buildSingleElementListIterable().iterator();
		String string = stream.next();
		try {
			string = stream.next();
			fail("bogus element: " + string);
		} catch (NoSuchElementException ex) {
			exCaught = true;
		}
		assertTrue(exCaught);
	}

	public void testRemove() {
		boolean exCaught = false;
		for (Iterator<String> stream = this.buildSingleElementListIterable().iterator(); stream.hasNext(); ) {
			if (stream.next().equals(this.singleElement())) {
				try {
					stream.remove();
				} catch (UnsupportedOperationException ex) {
					exCaught = true;
				}
			}
		}
		assertTrue("UnsupportedOperationException not thrown", exCaught);
	}

	public void testToString() {
		assertNotNull(this.buildSingleElementListIterable().toString());
	}

	protected Iterable<String> buildSingleElementListIterable() {
		return new SingleElementListIterable<String>(this.singleElement());
	}

	protected String singleElement() {
		return "single element";
	}
}