/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.sql.Time;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class TimeFromStringTest
extends AutoVerifyTestCase {
    String currentTime;
    Time nonOptimizedTime;
    Time optimizedTime;
    boolean optimizedDatesState;

    public static void main(String[] args) {
        TimeFromStringTest test = new TimeFromStringTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public TimeFromStringTest() {
        this.setDescription("Test of Helper.timeFromString(String timestampString)");
    }

    public void setup() {
        this.currentTime = new Time(System.currentTimeMillis()).toString();
        this.optimizedDatesState = Helper.shouldOptimizeDates();
    }

    public void test() {
        Helper.setShouldOptimizeDates((boolean)false);
        this.nonOptimizedTime = Helper.timeFromString((String)this.currentTime);
        Helper.setShouldOptimizeDates((boolean)true);
        this.optimizedTime = Helper.timeFromString((String)this.currentTime);
    }

    public void verify() {
        if (!this.currentTime.equals(this.nonOptimizedTime.toString())) {
            throw new TestErrorException("Failed to convert String to java.sql.Time when shouldOptimizedDates is off");
        }
        if (!this.currentTime.equals(this.optimizedTime.toString())) {
            throw new TestErrorException("Failed to convert String to java.sql.Time when shouldOptimizedDates is on");
        }
    }

    public void reset() {
        Helper.setShouldOptimizeDates((boolean)this.optimizedDatesState);
    }
}

