/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleQueryTestSuite {
    private static EntityManagerFactory emf = null;
    private EntityManager em = null;
    private SessionLog log;

    @BeforeClass
    public static void setUp() {
        emf = DynamicTestHelper.createEMF("dynamic");
    }

    @AfterClass
    public static void tearDown() {
        if (emf != null && emf.isOpen()) {
            emf.close();
        }
    }

    public void initTable() {
        EntityTransaction et = this.em.getTransaction();
        et.begin();
        try {
            this.em.createNativeQuery("CREATE TABLE SIMPLE_TYPE_1 (SID INT, VAL_1 VARCHAR(15), VAL_2 BOOLEAN)").executeUpdate();
            et.commit();
        }
        catch (Exception ex) {
            this.log.log(6, "Could not create SIMPLE_TYPE_1 table: ." + ex.getMessage());
            et.rollback();
        }
        et.begin();
        try {
            this.em.createNativeQuery("DELETE FROM SIMPLE_TYPE_1").executeUpdate();
            et.commit();
        }
        catch (Exception ex) {
            this.log.log(6, "Could not clean SIMPLE_TYPE_1 table: ." + ex.getMessage());
            et.rollback();
            throw ex;
        }
    }

    public void destroyTable() {
        EntityTransaction et = this.em.getTransaction();
        et.begin();
        try {
            this.em.createNativeQuery("DROP TABLE SIMPLE_TYPE").executeUpdate();
            et.commit();
        }
        catch (Exception ex) {
            this.log.log(6, "Could not drop SIMPLE_TYPE_1 table: ." + ex.getMessage());
            et.rollback();
        }
    }

    @Before
    public void setUpTest() {
        this.em = emf.createEntityManager();
        this.log = ((Session)this.em.unwrap(Session.class)).getSessionLog();
        this.initTable();
    }

    @After
    public void tearDownTest() {
        this.destroyTable();
        this.em.close();
        this.em = null;
        this.log = null;
    }

    @Test
    public void testJPQLQuery() {
        SessionLog log = ((Session)this.em.unwrap(Session.class)).getSessionLog();
        EntityTransaction et = this.em.getTransaction();
        try {
            et.begin();
            JPADynamicHelper helper = new JPADynamicHelper(this.em);
            DynamicClassLoader dcl = helper.getDynamicClassLoader();
            Class javaType = dcl.createDynamicClass("model.Simple");
            JPADynamicTypeBuilder typeBuilder = new JPADynamicTypeBuilder(javaType, null, new String[]{"SIMPLE_TYPE_1"});
            typeBuilder.setPrimaryKeyFields(new String[]{"SID"});
            typeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
            typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
            DynamicType dt = typeBuilder.getType();
            helper.addTypes(false, false, new DynamicType[]{dt});
            DynamicEntity dt1 = dt.newDynamicEntity();
            dt1.set("id", (Object)1);
            dt1.set("value1", (Object)"some string");
            this.em.persist((Object)dt1);
            this.em.flush();
            DynamicEntity jpqlEntity = (DynamicEntity)this.em.createQuery("SELECT s FROM Simple s", dt.getJavaClass()).getSingleResult();
            DynamicEntity foundEntity = (DynamicEntity)this.em.find(dt.getJavaClass(), (Object)1);
            Assert.assertEquals((Object)jpqlEntity, (Object)foundEntity);
            et.commit();
        }
        catch (RollbackException e) {
            et.rollback();
            throw new RuntimeException(e);
        }
    }
}

