/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkExceptionDialog;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;

final class RunnableProjectLoader
implements Runnable {
    private volatile FrameworkNodeManager nodeManager;
    private File projectFile;
    private WorkbenchContext context;
    Dialog waitDialog;

    RunnableProjectLoader(FrameworkNodeManager nodeManager, File projectFile, WorkbenchContext context) {
        this.nodeManager = nodeManager;
        this.projectFile = projectFile;
        this.context = context;
        this.waitDialog = this.buildWaitDialog();
    }

    private Dialog buildWaitDialog() {
        Window owner = this.context.getCurrentWindow();
        ResourceRepository rr = this.context.getApplicationContext().getResourceRepository();
        Icon icon = rr.getIcon("file.mwp.large");
        String title = rr.getString("PROJECT_LOADER_DIALOG.TITLE");
        String message = rr.getString("OPENING_PROJECT_MESSAGE", this.projectFile.getName());
        return owner instanceof Frame ? new WaitDialog((Frame)owner, icon, title, message) : new WaitDialog((Dialog)owner, icon, title, message);
    }

    @Override
    public void run() {
        try {
            this.run2();
        }
        catch (Throwable t) {
            this.waitDialog.dispose();
            EventQueue.invokeLater(this.buildDialogLauncher(this.buildExceptionDialog("OPEN_EXCEPTION", new Object[]{this.projectFile.getName()}, t)));
        }
    }

    private void run2() throws InterruptedException, InvocationTargetException {
        EventQueue.invokeLater(this.buildDialogLauncher(this.waitDialog));
        ApplicationNode node = null;
        try {
            node = this.nodeManager.openCallback(this.projectFile, this.context);
        }
        catch (OpenException ex) {
            this.waitDialog.dispose();
            EventQueue.invokeLater(this.buildDialogLauncher(this.buildExceptionDialog("OPEN_EXCEPTION", new Object[]{this.projectFile.getName()}, ex)));
            return;
        }
        catch (UnsupportedFileException ex) {
            this.waitDialog.dispose();
            EventQueue.invokeLater(this.buildDialogLauncher(this.buildExceptionDialog("UNSUPPORTED_FILE_TYPE", new Object[]{this.projectFile.getName()}, ex)));
            return;
        }
        catch (CancelException exception) {
            this.waitDialog.dispose();
            return;
        }
        EventQueue.invokeAndWait(new NodeInstaller(this.nodeManager, node, this.projectFile, this.context));
        this.waitDialog.dispose();
    }

    private Runnable buildDialogLauncher(final Dialog d) {
        return new Runnable(){

            @Override
            public void run() {
                d.show();
            }
        };
    }

    Dialog buildExceptionDialog(String messageKey, Object[] messageArguments, Throwable exception) {
        Window owner = this.context.getCurrentWindow();
        String message = this.context.getApplicationContext().getResourceRepository().getString(messageKey, messageArguments);
        return owner instanceof Frame ? new FrameworkExceptionDialog(message, exception, this.context) : new FrameworkExceptionDialog(message, exception, this.context, (Dialog)owner);
    }

    private static class NodeInstaller
    implements Runnable {
        private FrameworkNodeManager nodeManager;
        private ApplicationNode projectNode;
        private File projectFile;
        private WorkbenchContext context;

        NodeInstaller(FrameworkNodeManager nodeManager, ApplicationNode projectNode, File projectFile, WorkbenchContext context) {
            this.nodeManager = nodeManager;
            this.projectNode = projectNode;
            this.projectFile = projectNode.saveFile() != null ? projectNode.saveFile() : projectFile;
            this.context = context;
        }

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("this method must be executed in the AWT event dispatcher thread");
            }
            this.nodeManager.addProjectNodeCallback(this.projectNode, this.projectFile, this.context);
        }
    }
}

