/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ProjectCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorCreationFailuresDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassLoadFailuresDialog;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class RefreshClassesAction
extends AbstractFrameworkAction {
    public static final String EJB_JAR_XML_EXCEPTION_ERROR = "EJB_JAR_XML_EXCEPTION_ERROR";
    public static final String EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR = "EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR";
    public static final String INVALID_DOC_TYPE_ERROR = "INVALID_DOC_TYPE_ERROR";

    RefreshClassesAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        this.initializeTextAndMnemonic("REFRESH_CLASSES_ACTION");
        this.initializeAccelerator("REFRESH_CLASSES_ACTION.accelerator");
        this.initializeToolTipText("REFRESH_CLASSES_ACTION.toolTipText");
        this.initializeIcon("synchronize");
    }

    @Override
    protected void execute() {
        this.navigatorSelectionModel().pushExpansionState();
        this.refreshDescriptors(this.selectedProjectNodes(), this.selectedNodes());
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private void refreshDescriptors(ApplicationNode[] projectNodes, ApplicationNode[] selectedNodes) {
        for (int i = 0; i < projectNodes.length; ++i) {
            ((MWProject)projectNodes[i].getValue()).getRepository().refreshExternalClassDescriptions();
        }
        ExternalClassLoadFailureContainer failures = new ExternalClassLoadFailureContainer();
        DescriptorCreationFailureContainer descriptorCreationFailures = new DescriptorCreationFailureContainer();
        HashBag descriptors = new HashBag();
        for (int i = 0; i < selectedNodes.length; ++i) {
            ((MappingsApplicationNode)selectedNodes[i]).addDescriptorsTo((Collection)descriptors);
        }
        Iterator stream = descriptors.uniqueIterator();
        while (stream.hasNext()) {
            boolean anyInheritedAttributes = false;
            if (((MWDescriptor)stream.next()).inheritedAttributesSize() > 0) {
                anyInheritedAttributes = true;
            }
            if (!anyInheritedAttributes || !this.promptToRefreshWithInheritedAttributes(this.getWorkbenchContext())) continue;
            return;
        }
        stream = descriptors.uniqueIterator();
        while (stream.hasNext()) {
            ((MWDescriptor)stream.next()).refreshClass(failures, (DescriptorCreationFailureListener)descriptorCreationFailures);
        }
        if (failures.containsFailures()) {
            new ExternalClassLoadFailuresDialog(this.getWorkbenchContext(), failures).show();
            return;
        }
        if (descriptorCreationFailures.containsFailures()) {
            new DescriptorCreationFailuresDialog(descriptorCreationFailures, this.getWorkbenchContext()).show();
        }
    }

    private boolean canReadWithProblems(MWProject project, LinkedHashMap problems) {
        StatusDialog.Status status = StatusDialog.createStatus((Object)project, problems);
        CustomizedStatusDialog dialog = new CustomizedStatusDialog(Collections.singleton(status));
        dialog.setVisible(true);
        return dialog.wasConfirmed();
    }

    private void showResult(Collection results) {
        StatusDialog dialog = new StatusDialog(this.getWorkbenchContext(), results, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_EJB_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml"){

            @Override
            protected CellRendererAdapter buildNodeRenderer(Object value) {
                if (value instanceof MWProject) {
                    return new ProjectCellRendererAdapter(this.resourceRepository());
                }
                return super.buildNodeRenderer(value);
            }
        };
        dialog.setVisible(true);
    }

    private boolean promptToUpdateProjectFromEjbJarXml(WorkbenchContext workbenchContext) {
        int option = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR"), this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR.title"), 0);
        return option == 0;
    }

    private boolean promptToRefreshWithInheritedAttributes(WorkbenchContext workbenchContext) {
        int option = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("REFRESH_DESCRIPTORS_WITH_INHERITED_ATTRIBUTES_WARNING", StringTools.CR), this.resourceRepository().getString("REFRESH_DESCRIPTORS_WITH_INHERITED_ATTRIBUTES_TITLE"), 0, 2);
        return option == 1;
    }

    private class CustomizedStatusDialog
    extends StatusDialog {
        private CustomizedStatusDialog(Collection projectStatus) {
            super(RefreshClassesAction.this.getWorkbenchContext(), projectStatus, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml");
        }

        @Override
        protected Action buildCancelAction() {
            AbstractAction action = (AbstractAction)super.buildCancelAction();
            action.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON"));
            action.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON")));
            return action;
        }

        @Override
        protected CellRendererAdapter buildNodeRenderer(Object value) {
            if (value instanceof MWProject) {
                return new ProjectCellRendererAdapter(this.resourceRepository());
            }
            return super.buildNodeRenderer(value);
        }

        @Override
        protected Action buildOKAction() {
            AbstractAction action = (AbstractAction)super.buildOKAction();
            action.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON"));
            action.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON")));
            return action;
        }

        @Override
        protected boolean cancelButtonIsVisible() {
            return true;
        }
    }
}

