/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class LoginSpecPanel
extends AbstractPanel {
    private PropertyValueModel selectedLoginSpecHolder;

    public LoginSpecPanel(PropertyValueModel selectedLoginSpecHolder, ApplicationContext context) {
        super(context);
        this.initialize(selectedLoginSpecHolder);
    }

    protected void initialize(PropertyValueModel selectedLoginSpecHolder) {
        this.selectedLoginSpecHolder = selectedLoginSpecHolder;
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel driverLabel = this.buildLabel("DRIVER_CLASS_COMBO_BOX_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)driverLabel, constraints);
        driverLabel.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(driverLabel));
        this.addAlignLeft(driverLabel);
        JComboBox driverClassComboBox = this.buildDriverClassComboBox();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)driverClassComboBox, constraints);
        driverLabel.setLabelFor(driverClassComboBox);
        driverClassComboBox.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(driverClassComboBox));
        JLabel urlLabel = this.buildLabel("URL_COMBO_BOX_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)urlLabel, constraints);
        urlLabel.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(urlLabel));
        this.addAlignLeft(urlLabel);
        JComboBox urlComboBox = this.buildConnectionUrlComboBox();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)urlComboBox, constraints);
        urlLabel.setLabelFor(urlComboBox);
        urlComboBox.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(urlComboBox));
        JLabel userNameLabel = this.buildLabel("USERNAME_TEXT_FIELD_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)userNameLabel, constraints);
        userNameLabel.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(userNameLabel));
        this.addAlignLeft(userNameLabel);
        JTextField userNameField = this.buildUserNameTextField();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)userNameField, constraints);
        userNameLabel.setLabelFor(userNameField);
        userNameField.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(userNameField));
        JLabel passwordLabel = this.buildLabel("PASSWORD_TEXT_FIELD_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)passwordLabel, constraints);
        passwordLabel.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(passwordLabel));
        this.addAlignLeft(passwordLabel);
        JPasswordField passwordField = this.buildPasswordField();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)passwordField, constraints);
        passwordLabel.setLabelFor(passwordField);
        passwordField.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(passwordField));
        JCheckBox savePasswordCheckBox = this.buildSavePasswordCheckBox();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)savePasswordCheckBox, constraints);
        savePasswordCheckBox.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(savePasswordCheckBox));
    }

    private JComboBox buildDriverClassComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildSortedDriverClassesHolder(), this.buildDriverClassAdapter()));
        comboBox.setEditable(true);
        return comboBox;
    }

    private ListValueModel buildSortedDriverClassesHolder() {
        return new SortedListValueModelAdapter(this.buildAllDriverClassesAdapter());
    }

    private CollectionValueModel buildAllDriverClassesAdapter() {
        return new CollectionAspectAdapter(this.selectedLoginSpecHolder){

            @Override
            protected Iterator getValueFromSubject() {
                return LoginSpecPanel.this.compositeDriverClassIterator(MWLoginSpec.commonDriverClassNames());
            }

            @Override
            protected int sizeFromSubject() {
                return LoginSpecPanel.this.compositeDriverClassSize(MWLoginSpec.commonDriverClassNamesSize());
            }
        };
    }

    private Iterator compositeDriverClassIterator(Iterator commonDriverClassNames) {
        String name = this.preferences().get("database driver class", null);
        if (name != null) {
            return new CompositeIterator(commonDriverClassNames, (Iterator)new SingleElementIterator((Object)name));
        }
        return commonDriverClassNames;
    }

    private int compositeDriverClassSize(int originalSize) {
        String name = this.preferences().get("database driver class", null);
        if (name != null) {
            ++originalSize;
        }
        return originalSize;
    }

    private PropertyValueModel buildDriverClassAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "driverClassName"){

            @Override
            protected Object getValueFromSubject() {
                String name = ((MWLoginSpec)this.subject).getDriverClassName();
                if (name == null && (name = LoginSpecPanel.this.preferences().get("database driver class", null)) != null) {
                    ((MWLoginSpec)this.subject).setDriverClassName(name);
                }
                return name;
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWLoginSpec)this.subject).setDriverClassName((String)value);
            }
        };
    }

    private JComboBox buildConnectionUrlComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildSortedConnectionUrlsHolder(), this.buildConnectionUrlAdapter()));
        comboBox.setEditable(true);
        return comboBox;
    }

    private ListValueModel buildSortedConnectionUrlsHolder() {
        return new SortedListValueModelAdapter(this.buildAllConnectionUrlsAdapter());
    }

    private CollectionValueModel buildAllConnectionUrlsAdapter() {
        return new CollectionAspectAdapter(this.selectedLoginSpecHolder, "candidateURLs"){

            @Override
            protected Iterator getValueFromSubject() {
                return LoginSpecPanel.this.compositeConnectionUrlIterator(((MWLoginSpec)this.subject).candidateURLs());
            }

            @Override
            protected int sizeFromSubject() {
                return LoginSpecPanel.this.compositeConnectionUrlSize(((MWLoginSpec)this.subject).candidateURLsSize());
            }
        };
    }

    private Iterator compositeConnectionUrlIterator(Iterator connectionUrls) {
        String url = this.preferences().get("database connection url", null);
        if (url != null) {
            return new CompositeIterator(connectionUrls, (Iterator)new SingleElementIterator((Object)url));
        }
        return connectionUrls;
    }

    private int compositeConnectionUrlSize(int originalSize) {
        String url = this.preferences().get("database connection url", null);
        if (url != null) {
            ++originalSize;
        }
        return originalSize;
    }

    private PropertyValueModel buildConnectionUrlAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "url"){

            @Override
            protected Object getValueFromSubject() {
                String url = ((MWLoginSpec)this.subject).getURL();
                if (url == null && (url = LoginSpecPanel.this.preferences().get("database connection url", null)) != null) {
                    ((MWLoginSpec)this.subject).setURL(url);
                }
                return url;
            }

            @Override
            protected void setValueOnSubject(Object value) {
                String string = (String)value;
                MWLoginSpec loginSpec = (MWLoginSpec)this.subject;
                if (string == null || string.length() == 0) {
                    loginSpec.setURL(null);
                } else {
                    loginSpec.setURL(string);
                }
            }
        };
    }

    private JTextField buildUserNameTextField() {
        return new JTextField(this.buildUserNameDocumentAdapter(), null, 1);
    }

    private Document buildUserNameDocumentAdapter() {
        return new DocumentAdapter(this.buildUserNameAdapter());
    }

    private PropertyValueModel buildUserNameAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "userName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWLoginSpec)this.subject).getUserName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWLoginSpec)this.subject).setUserName((String)value);
            }
        };
    }

    private JPasswordField buildPasswordField() {
        return new JPasswordField(this.buildPasswordDocumentAdapter(), null, 1);
    }

    private Document buildPasswordDocumentAdapter() {
        return new DocumentAdapter(this.buildPasswordAdapter());
    }

    private PropertyValueModel buildPasswordAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "password"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWLoginSpec)this.subject).getPassword();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWLoginSpec)this.subject).setPassword((String)value);
            }
        };
    }

    private JCheckBox buildSavePasswordCheckBox() {
        return this.buildCheckBox("SAVE_PASSWORD_CHECK_BOX", this.buildSavePasswordCheckBoxModelAdapter());
    }

    private ButtonModel buildSavePasswordCheckBoxModelAdapter() {
        return new CheckBoxModelAdapter(this.buildSavePasswordPropertyAdapter());
    }

    private PropertyValueModel buildSavePasswordPropertyAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "savePassword"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWLoginSpec)this.subject).isSavePassword();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWLoginSpec)this.subject).setSavePassword(((Boolean)value).booleanValue());
            }
        };
    }

    private PropertyChangeListener buildSelectedLoginInfoListener(final Component component) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(evt.getNewValue() != null);
            }
        };
    }
}

