/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWClassBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMethodBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerEditingPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class TransformerEditingDialog
extends AbstractValidatingDialog {
    private TransformerEditor transformerEditor;
    private boolean noError = true;

    public static void promptToEditAttributeTransformer(MWTransformationMapping transformationMapping, WorkbenchContext context) {
        AttributeTransformerEditor editor = new AttributeTransformerEditor(transformationMapping);
        TransformerEditingDialog dialog = new TransformerEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
        }
    }

    public static void promptToAddFieldTransformerAssociationForAggregate(MWRelationalTransformationMapping transformationMapping, WorkbenchContext context) {
        MWRelationalFieldTransformerAssociation association = transformationMapping.buildEmptyFieldTransformerAssociation();
        FieldTransformerEditor editor = new FieldTransformerEditor((MWFieldTransformerAssociation)association);
        TransformerEditingDialog dialog = new TransformerEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
            transformationMapping.addFieldTransformerAssociation((MWFieldTransformerAssociation)association);
        }
    }

    public static void promptToEditFieldTransformerAssociationForAggregate(MWRelationalFieldTransformerAssociation association, WorkbenchContext context) {
        FieldTransformerEditor editor = new FieldTransformerEditor((MWFieldTransformerAssociation)association);
        TransformerEditingDialog dialog = new TransformerEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
        }
    }

    private TransformerEditingDialog(TransformerEditor transformerEditor, WorkbenchContext context) {
        super(context);
        this.initialize(transformerEditor);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("TRANSFORMER_EDITING_DIALOG.TITLE"));
        this.getOKAction().setEnabled(false);
    }

    private void initialize(TransformerEditor transformerEditor) {
        this.transformerEditor = transformerEditor;
        this.transformerEditor.transformationMethodHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.transformerEditor.transformerClassHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.transformerEditor.transformerTypeHolder().addPropertyChangeListener("value", this.buildValidatingListener());
    }

    private PropertyChangeListener buildValidatingListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransformerEditingDialog.this.updateErrorMessage();
                TransformerEditingDialog.this.updateOKAction();
            }
        };
    }

    private void updateErrorMessage() {
        if (this.transformerEditor.transformerType() == "nullTransformer") {
            this.setErrorMessageKey("TRANSFORMER_EDITING_DIALOG.NULL_TRANSFORMER_ERROR");
        } else if (this.transformerEditor.transformerType() == "transformerClass" && this.transformerEditor.transformerClass() == null) {
            this.setErrorMessageKey("TRANSFORMER_EDITING_DIALOG.NULL_TRANSFORMER_CLASS_ERROR");
        } else if (this.transformerEditor.transformerType() == "transformationMethod" && this.transformerEditor.transformationMethod() == null) {
            this.setErrorMessageKey("TRANSFORMER_EDITING_DIALOG.NULL_TRANSFORMATION_METHOD_ERROR");
        } else {
            this.clearErrorMessage();
        }
        if (this.transformerEditor.transformerType() == "transformationMethod" && this.transformerEditor.transformationMethod() != null && !this.transformerEditor.transformationMethodIsValid()) {
            this.setWarningMessageKey("TRANSFORMER_EDITING_DIALOG.INVALID_TRANSFORMATION_METHOD_WARNING");
        } else {
            this.clearWarningMessage();
        }
    }

    @Override
    protected void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.noError = message == null;
    }

    @Override
    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.noError = true;
    }

    private void updateOKAction() {
        this.getOKAction().setEnabled(this.noError);
    }

    @Override
    protected Component buildMainPanel() {
        return new TransformerEditingPanel(this.transformerEditor, (WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
    }

    @Override
    protected String helpTopicId() {
        return "dialog.editTransformer";
    }

    @Override
    protected void prepareToShow() {
        super.prepareToShow();
        this.setSize(Math.max(500, this.getWidth()), this.getHeight());
    }

    static class FieldTransformerEditor
    extends AbstractTransformerEditor {
        private MWFieldTransformerAssociation association;

        FieldTransformerEditor(MWFieldTransformerAssociation association) {
            this.association = association;
        }

        @Override
        protected MWTransformationMapping transformationMapping() {
            return this.association.getMapping();
        }

        @Override
        public Iterator candidateTransformationMethods() {
            return this.transformationMapping().candidateFieldTransformationMethods();
        }

        @Override
        public boolean transformationMethodIsValid() {
            return this.transformationMethod().isCandidateFieldTransformerMethod();
        }

        @Override
        protected PropertyValueModel buildInternalMethodHolder() {
            return new PropertyAspectAdapter("fieldTransformer", (Model)this.association){

                @Override
                protected Object getValueFromSubject() {
                    MWTransformer transformer = ((MWFieldTransformerAssociation)this.subject).getFieldTransformer();
                    if (transformer instanceof MWMethodBasedTransformer) {
                        return ((MWMethodBasedTransformer)transformer).getMethod();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWFieldTransformerAssociation)this.subject).setFieldTransformer((MWMethod)value);
                }
            };
        }

        @Override
        protected PropertyValueModel buildInternalClassHolder() {
            return new PropertyAspectAdapter("fieldTransformer", (Model)this.association){

                @Override
                protected Object getValueFromSubject() {
                    MWTransformer transformer = ((MWFieldTransformerAssociation)this.subject).getFieldTransformer();
                    if (transformer instanceof MWClassBasedTransformer) {
                        return ((MWClassBasedTransformer)transformer).getTransformerClass();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWFieldTransformerAssociation)this.subject).setFieldTransformer((MWClass)value);
                }
            };
        }
    }

    static class AttributeTransformerEditor
    extends AbstractTransformerEditor {
        private MWTransformationMapping transformationMapping;

        private AttributeTransformerEditor(MWTransformationMapping transformationMapping) {
            this.transformationMapping = transformationMapping;
        }

        @Override
        protected MWTransformationMapping transformationMapping() {
            return this.transformationMapping;
        }

        @Override
        public Iterator candidateTransformationMethods() {
            return this.transformationMapping().candidateAttributeTransformationMethods();
        }

        @Override
        public boolean transformationMethodIsValid() {
            return this.transformationMethod().isCandidateAttributeTransformerMethod();
        }

        @Override
        protected PropertyValueModel buildInternalMethodHolder() {
            return new PropertyAspectAdapter("attributeTransformer", (Model)this.transformationMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWTransformer transformer = ((MWTransformationMapping)this.subject).getAttributeTransformer();
                    if (transformer instanceof MWMethodBasedTransformer) {
                        return ((MWMethodBasedTransformer)transformer).getMethod();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWTransformationMapping)this.subject).setAttributeTransformer((MWMethod)value);
                }
            };
        }

        @Override
        protected PropertyValueModel buildInternalClassHolder() {
            return new PropertyAspectAdapter("attributeTransformer", (Model)this.transformationMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWTransformer transformer = ((MWTransformationMapping)this.subject).getAttributeTransformer();
                    if (transformer instanceof MWClassBasedTransformer) {
                        return ((MWClassBasedTransformer)transformer).getTransformerClass();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWTransformationMapping)this.subject).setAttributeTransformer((MWClass)value);
                }
            };
        }
    }

    static abstract class AbstractTransformerEditor
    implements TransformerEditor {
        private PropertyValueModel transformerTypeHolder;
        private BufferedPropertyValueModel methodHolder;
        private BufferedPropertyValueModel.Trigger methodTrigger = new BufferedPropertyValueModel.Trigger();
        private BufferedPropertyValueModel classHolder;
        private BufferedPropertyValueModel.Trigger classTrigger = new BufferedPropertyValueModel.Trigger();

        protected AbstractTransformerEditor() {
        }

        @Override
        public PropertyValueModel transformerTypeHolder() {
            if (this.transformerTypeHolder == null) {
                this.transformerTypeHolder = this.buildTransformerTypeHolder();
            }
            return this.transformerTypeHolder;
        }

        protected PropertyValueModel buildTransformerTypeHolder() {
            String transformerType = "nullTransformer";
            if (this.transformerClass() != null) {
                transformerType = "transformerClass";
            } else if (this.transformationMethod() != null) {
                transformerType = "transformationMethod";
            }
            return new SimplePropertyValueModel(transformerType);
        }

        @Override
        public String transformerType() {
            return (String)this.transformerTypeHolder().getValue();
        }

        @Override
        public PropertyValueModel transformationMethodHolder() {
            if (this.methodHolder == null) {
                this.methodHolder = this.buildMethodHolder();
            }
            return this.methodHolder;
        }

        private BufferedPropertyValueModel buildMethodHolder() {
            return new BufferedPropertyValueModel(this.buildInternalMethodHolder(), this.methodTrigger);
        }

        protected abstract PropertyValueModel buildInternalMethodHolder();

        @Override
        public MWMethod transformationMethod() {
            return (MWMethod)this.transformationMethodHolder().getValue();
        }

        @Override
        public PropertyValueModel transformerClassHolder() {
            if (this.classHolder == null) {
                this.classHolder = this.buildClassHolder();
            }
            return this.classHolder;
        }

        private BufferedPropertyValueModel buildClassHolder() {
            return new BufferedPropertyValueModel(this.buildInternalClassHolder(), this.classTrigger);
        }

        protected abstract PropertyValueModel buildInternalClassHolder();

        @Override
        public MWClass transformerClass() {
            return (MWClass)this.transformerClassHolder().getValue();
        }

        @Override
        public MWClassRepository classRepository() {
            return this.transformationMapping().getRepository();
        }

        protected abstract MWTransformationMapping transformationMapping();

        @Override
        public void commit() {
            if (this.transformerType() == "transformationMethod") {
                this.methodTrigger.accept();
            } else if (this.transformerType() == "transformerClass") {
                this.classTrigger.accept();
            }
        }
    }

    public static interface TransformerEditor
    extends TransformerEditingPanel.TransformerSpec {
        public void commit();
    }
}

