/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.property.PropertyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Property;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.PropertyAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequencingAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public abstract class LoginAdapter
extends SCAdapter
implements Property {
    public static final String PLATFORM_CLASS_PROPERTY = "platformClass";
    public static final String USER_NAME_PROPERTY = "userName";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String TABLE_QUALIFIER_PROPERTY = "tableQualifier";
    public static final String ENCRYPTION_CLASS_PROPERTY = "encryptionClass";
    public static final String EXTERNAL_TRANSACTION_CONTROLLER_PROPERTY = "externalTransactionController";
    public static final String EXTERNAL_CONNECTION_POOLING_PROPERTY = "externalConnectionPooling";
    public static final String DEFAULT_SEQUENCE_PROPERTY = "defaultSequence";
    private volatile SequencingAdapter sequencing;
    public static final String SEQUENCES_COLLECTION = "sequences";
    public static final String SEQUENCE_PREALLOCATION_SIZE_PROPERTY = "sequencePreallocationSize";
    public static final String SEQUENCE_TABLE_PROPERTY = "sequenceTable";
    public static final String SEQUENCE_NAME_FIELD_PROPERTY = "sequenceNameField";
    public static final String SEQUENCE_COUNTER_FIELD_PROPERTY = "sequenceCounterField";
    private volatile Collection properties;
    private Boolean savePassword;
    public static final String SAVE_PASSWORD_PROPERTY = "savePassword";
    private Boolean saveUserName;
    public static final String SAVE_USERNAME_PROPERTY = "saveUsername";

    LoginAdapter(SCAdapter parent, LoginConfig scConfig) {
        super(parent, scConfig);
    }

    protected LoginAdapter(SCAdapter parent) {
        super(parent);
    }

    LoginAdapter() {
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.sequencing != null) {
            children.add(this.sequencing);
        }
    }

    public SequenceAdapter setDefaultTableSequenceTable() {
        SequenceAdapter old = this.sequencing.getDefaultSequence();
        SequenceAdapter sequence = this.sequencing.setDefaultTableSequenceTable("Default", this.getSequencePreallocationSize());
        this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, old, sequence);
        return sequence;
    }

    public SequenceAdapter setNativeSequencing() {
        SequenceAdapter old = this.sequencing.getDefaultSequence();
        SequenceAdapter sequence = this.sequencing.setNativeSequencing("Native", this.getSequencePreallocationSize());
        this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, old, sequence);
        return sequence;
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
    }

    public void removeSequenceNamed(String name) {
        SequenceAdapter sequence = this.sequencing.removeSequenceNamed(name);
        if (sequence != null) {
            this.fireItemRemoved(SEQUENCES_COLLECTION, sequence);
        }
    }

    public int getSequencePreallocationSize() {
        if (this.getDefaultSequence() == null) {
            return 50;
        }
        return this.sequencing.getDefaultSequencePreallocationSize();
    }

    public void setSequencePreallocationSize(int value) {
        int old = this.getSequencePreallocationSize();
        this.sequencing.setDefaultSequencePreallocationSize(value);
        this.firePropertyChanged(SEQUENCE_PREALLOCATION_SIZE_PROPERTY, old, value);
    }

    public String getSequenceTable() {
        return this.sequencing.getTableSequenceTable();
    }

    public void setSequenceTable(String value) {
        String old = this.getSequenceTable();
        this.sequencing.setTableSequenceTable(value);
        this.firePropertyChanged(SEQUENCE_TABLE_PROPERTY, old, value);
    }

    public String getSequenceNameField() {
        return this.sequencing.getTableSequenceNameField();
    }

    public void setSequenceNameField(String value) {
        String old = this.getSequenceNameField();
        this.sequencing.setTableSequenceNameField(value);
        this.firePropertyChanged(SEQUENCE_NAME_FIELD_PROPERTY, old, value);
    }

    public String getSequenceCounterField() {
        return this.sequencing.getTableSequenceCounterField();
    }

    public void setSequenceCounterField(String value) {
        String old = this.getSequenceCounterField();
        this.sequencing.setTableSequenceCounterField(value);
        this.firePropertyChanged(SEQUENCE_COUNTER_FIELD_PROPERTY, old, value);
    }

    public String getPlatformName() {
        if (this.getPlatformClass() == null) {
            return "Unknown Data Source";
        }
        String className = ClassTools.shortNameForClassNamed((String)this.getPlatformClass());
        className = className.replaceAll("Platform", "");
        return className;
    }

    protected abstract String getDefaultPlatformClassName();

    public String getPlatformClass() {
        return this.loginConfig().getPlatformClass();
    }

    public void setPlatformClass(String value) {
        String old = this.loginConfig().getPlatformClass();
        this.loginConfig().setPlatformClass(value);
        this.firePropertyChanged(PLATFORM_CLASS_PROPERTY, old, value);
    }

    public String getUserName() {
        return this.loginConfig().getUsername();
    }

    public void setUserName(String name) {
        String old = this.loginConfig().getUsername();
        this.loginConfig().setUsername(name);
        this.firePropertyChanged(USER_NAME_PROPERTY, old, name);
    }

    public String getPassword() {
        return this.loginConfig().getPassword();
    }

    public void setPassword(String value) {
        String old = this.loginConfig().getPassword();
        this.loginConfig().setPassword(value);
        this.firePropertyChanged(PASSWORD_PROPERTY, old, value);
    }

    public Boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(Boolean savePassword) {
        Boolean old = this.isSavePassword();
        this.savePassword = savePassword;
        this.firePropertyChanged(SAVE_PASSWORD_PROPERTY, old, savePassword);
        if (!this.isSavePassword().booleanValue()) {
            this.setPassword(null);
        }
    }

    public Boolean isSaveUsername() {
        return this.saveUserName;
    }

    public void setSaveUsername(Boolean saveUsername) {
        Boolean old = this.isSaveUsername();
        this.saveUserName = saveUsername;
        this.firePropertyChanged(SAVE_USERNAME_PROPERTY, old, saveUsername);
        if (!this.isSaveUsername().booleanValue()) {
            this.setUserName(null);
        }
    }

    public String getTableQualifier() {
        return this.loginConfig().getTableQualifier();
    }

    public void setTableQualifier(String value) {
        String old = this.loginConfig().getTableQualifier();
        this.loginConfig().setTableQualifier(value);
        this.firePropertyChanged(TABLE_QUALIFIER_PROPERTY, old, value);
    }

    public String getEncryptionClass() {
        return this.loginConfig().getEncryptionClass();
    }

    public void setEncryptionClass(String value) {
        String old = this.loginConfig().getEncryptionClass();
        this.loginConfig().setEncryptionClass(value);
        this.firePropertyChanged(ENCRYPTION_CLASS_PROPERTY, old, value);
    }

    public boolean usesExternalConnectionPooling() {
        return this.loginConfig().getExternalConnectionPooling();
    }

    public void setExternalConnectionPooling(boolean value) {
        boolean old = this.loginConfig().getExternalConnectionPooling();
        this.loginConfig().setExternalConnectionPooling(value);
        this.firePropertyChanged(EXTERNAL_CONNECTION_POOLING_PROPERTY, old, value);
    }

    public boolean usesExternalTransactionController() {
        return this.loginConfig().getExternalTransactionController();
    }

    public void setUsesExternalTransactionController(boolean value) {
        boolean old = this.loginConfig().getExternalTransactionController();
        this.loginConfig().setExternalTransactionController(value);
        this.firePropertyChanged(EXTERNAL_TRANSACTION_CONTROLLER_PROPERTY, old, value);
    }

    public void toString(StringBuffer sb) {
        String platform = this.getPlatformClass();
        if (platform == null) {
            sb.append("no platform");
        } else {
            sb.append(ClassTools.shortNameForClassNamed((String)platform));
        }
    }

    @Override
    protected boolean isACleanConfig() {
        boolean cleanConfig = super.isACleanConfig();
        return cleanConfig && this.platformClassIsDefault();
    }

    protected boolean platformClassIsDefault() {
        return this.getDefaultPlatformClassName().equals(this.getPlatformClass());
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        if (this.loginConfig().getEncryptedPassword() == null) {
            this.loginConfig().setPassword("");
        } else if (this.loginConfig().getPassword() != null && !this.loginConfig().getPassword().equals("")) {
            this.setSavePassword(Boolean.TRUE);
        }
        if (this.loginConfig().getUsername() != null && !this.loginConfig().getUsername().equals("")) {
            this.setSaveUsername(Boolean.TRUE);
        }
        if (this.loginConfig().getPlatformClass() == null) {
            this.loginConfig().setPlatformClass(this.getDefaultPlatformClassName());
        }
        this.sequencing = this.loginConfig().getSequencingConfig() == null ? this.buildSequencing() : (SequencingAdapter)this.adapt(((LoginConfig)scConfig).getSequencingConfig());
        if (this.loginConfig().getPropertyConfigs() != null) {
            this.properties.addAll(this.adaptAll(this.loginConfig().getPropertyConfigs()));
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.properties = new Vector();
        this.savePassword = Boolean.FALSE;
        this.saveUserName = Boolean.FALSE;
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.sequencing = this.buildSequencing();
    }

    public boolean usesNativeSequencing() {
        return this.sequencing.usesNativeSequencing();
    }

    boolean platformIsRdbms() {
        return false;
    }

    boolean platformIsEis() {
        return false;
    }

    boolean platformIsXml() {
        return false;
    }

    public boolean databaseDriverIsDriverManager() {
        return false;
    }

    public boolean databaseDriverIsDataSource() {
        return false;
    }

    private final LoginConfig loginConfig() {
        return (LoginConfig)this.getModel();
    }

    protected SequencingAdapter getSequencing() {
        return this.sequencing;
    }

    protected SequencingConfig getSequenceConfig() {
        return this.loginConfig().getSequencingConfig();
    }

    @Override
    public Iterator properties() {
        return this.getProperties().iterator();
    }

    @Override
    public int propertySize() {
        return this.getProperties().size();
    }

    private Collection getProperties() {
        return this.properties;
    }

    private Collection getPropertyConfigs() {
        if (this.loginConfig().getPropertyConfigs() == null) {
            this.loginConfig().setPropertyConfigs(new Vector());
        }
        return this.loginConfig().getPropertyConfigs();
    }

    @Override
    public PropertyAdapter addProperty(String name, String value) {
        PropertyAdapter property = this.buildPropertyAdapter(name, value);
        this.getPropertyConfigs().add(property.propertyConfig());
        this.addItemToCollection((Object)property, this.getProperties(), "property");
        return property;
    }

    protected SequencingAdapter buildSequencing() {
        SequencingAdapter sequencing = new SequencingAdapter(this);
        return sequencing;
    }

    private PropertyAdapter buildPropertyAdapter(String name, String value) {
        return new PropertyAdapter((SCAdapter)this, this.buildPropertyConfig(name, value));
    }

    private PropertyConfig buildPropertyConfig(String name, String value) {
        PropertyConfig config = new PropertyConfig();
        config.setName(name);
        config.setValue(value);
        return config;
    }

    @Override
    public void removeProperty(PropertyAdapter property) {
        this.getPropertyConfigs().remove(property.propertyConfig());
        this.removeItemFromCollection((Object)property, this.getProperties(), "property");
    }

    protected void removeAllProperties() {
        Vector copy = new Vector(this.properties);
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            this.removeProperty((PropertyAdapter)((Object)iter.next()));
        }
    }

    public boolean sequencingIsDefault() {
        return this.sequencing.isDefault();
    }

    public boolean sequencingIsNative() {
        return this.sequencing.isNative();
    }

    public boolean sequencingIsCustom() {
        return this.sequencing.isCustom();
    }

    public SequenceAdapter getDefaultSequence() {
        return this.sequencing.getDefaultSequence();
    }

    public ListIterator<SequenceAdapter> sequences() {
        return this.sequencing.sequences();
    }

    public SequenceAdapter removeSequence(SequenceAdapter sequenceAdapter) {
        this.sequencing.removeSequence(sequenceAdapter);
        this.fireListChanged(SEQUENCES_COLLECTION);
        return sequenceAdapter;
    }

    public SequenceAdapter addSequence(String name, SequenceType sequenceType) {
        SequenceAdapter newAdapter = this.sequencing.addSequence(name, sequenceType);
        this.fireListChanged(SEQUENCES_COLLECTION);
        return newAdapter;
    }

    public SequenceAdapter createAndSetDefaultSequence(String name, SequenceType type) {
        SequenceAdapter old = this.getDefaultSequence();
        SequenceAdapter adapter = this.sequencing.createAndSetDefaultSequence(name, type);
        this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, old, adapter);
        return adapter;
    }

    public int sequencesSize() {
        return this.sequencing.sequencesSize();
    }

    public Iterator<String> sequenceNames() {
        return this.sequencing.sequenceNames();
    }
}

