/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class CloneListIterator
implements ListIterator {
    private ListIterator nestedListIterator;
    private int cursor;
    private String state;
    private Mutator mutator;
    private static final String UNKNOWN = "unknown";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";

    public CloneListIterator(List list) {
        this(list, Mutator.READ_ONLY_INSTANCE);
    }

    public CloneListIterator(List list, Mutator mutator) {
        this.nestedListIterator = CollectionTools.list(list.toArray()).listIterator();
        this.mutator = mutator;
        this.cursor = 0;
        this.state = UNKNOWN;
    }

    @Override
    public boolean hasNext() {
        return this.nestedListIterator.hasNext();
    }

    @Override
    public Object next() {
        Object next = this.nestedListIterator.next();
        ++this.cursor;
        this.state = NEXT;
        return next;
    }

    @Override
    public void remove() {
        this.nestedListIterator.remove();
        if (this.state == PREVIOUS) {
            this.remove(this.cursor);
        } else {
            --this.cursor;
            this.remove(this.cursor);
        }
    }

    @Override
    public int nextIndex() {
        return this.nestedListIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.nestedListIterator.previousIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.nestedListIterator.hasPrevious();
    }

    public Object previous() {
        Object previous = this.nestedListIterator.previous();
        --this.cursor;
        this.state = PREVIOUS;
        return previous;
    }

    public void add(Object o) {
        this.nestedListIterator.add(o);
        this.add(this.cursor, o);
        ++this.cursor;
    }

    public void set(Object o) {
        this.nestedListIterator.set(o);
        if (this.state == PREVIOUS) {
            this.set(this.cursor, o);
        } else {
            this.set(this.cursor - 1, o);
        }
    }

    protected void add(int index, Object o) {
        this.mutator.add(index, o);
    }

    protected void remove(int index) {
        this.mutator.remove(index);
    }

    protected void set(int index, Object o) {
        this.mutator.set(index, o);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this);
    }

    public static interface Mutator {
        public static final Mutator READ_ONLY_INSTANCE = new Mutator(){

            @Override
            public void add(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "ReadOnlyListMutator";
            }
        };

        public void add(int var1, Object var2);

        public void remove(int var1);

        public void set(int var1, Object var2);
    }
}

