/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.Map;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class NamespaceInfo {
    private String namespace;
    private boolean attributeFormQualified = false;
    private boolean elementFormQualified = false;
    private NamespaceResolver namespaceResolver;
    private String location;
    private NamespaceResolver namespaceResolverForDescriptor;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String ns) {
        if (ns != null) {
            ns = ns.intern();
        }
        this.namespace = ns;
    }

    public boolean isAttributeFormQualified() {
        return this.attributeFormQualified;
    }

    public void setAttributeFormQualified(boolean b) {
        this.attributeFormQualified = b;
    }

    public boolean isElementFormQualified() {
        return this.elementFormQualified;
    }

    public void setElementFormQualified(boolean b) {
        this.elementFormQualified = b;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public NamespaceResolver getNamespaceResolverForDescriptor(NamespaceResolver contextResolver, boolean canUseDefaultNamespace) {
        if (this.namespaceResolverForDescriptor == null) {
            String defaultNS;
            this.namespaceResolverForDescriptor = new NamespaceResolver();
            if (this.namespaceResolver.hasPrefixesToNamespaces()) {
                for (Map.Entry<String, String> entry : this.namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                    String namespace = entry.getValue();
                    if (namespace == null) continue;
                    this.addToDescriptorNamespaceResolver(false, entry.getKey(), namespace, contextResolver);
                }
            }
            if ((defaultNS = this.namespaceResolver.getDefaultNamespaceURI()) != null) {
                this.addToDescriptorNamespaceResolver(canUseDefaultNamespace, null, defaultNS, contextResolver);
            }
        }
        return this.namespaceResolverForDescriptor;
    }

    private void addToDescriptorNamespaceResolver(boolean asDefault, String prefix, String namespace, NamespaceResolver contextResolver) {
        String contextDefault = contextResolver.getDefaultNamespaceURI();
        if (asDefault && (contextDefault == null || contextDefault.equals(namespace))) {
            this.namespaceResolverForDescriptor.setDefaultNamespaceURI(namespace);
            contextResolver.setDefaultNamespaceURI(namespace);
        } else {
            String newPrefix = prefix == null || contextResolver.hasPrefix(prefix) || this.namespaceResolverForDescriptor.hasPrefix(prefix) ? this.getNamespacePrefixForDescriptorNamespaceResolver(namespace, contextResolver) : prefix;
            this.namespaceResolverForDescriptor.put(newPrefix, namespace);
            contextResolver.put(newPrefix, namespace);
        }
    }

    private String getNamespacePrefixForDescriptorNamespaceResolver(String namespace, NamespaceResolver contextResolver) {
        String prefix = contextResolver.resolveNamespaceURI(namespace);
        while (prefix == null || this.namespaceResolverForDescriptor.hasPrefix(prefix)) {
            prefix = contextResolver.generatePrefix();
        }
        return prefix;
    }
}

