/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.corba.sun.SunCORBATransportManager;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaSunCORBATransportConfigTest
extends AutoVerifyTestCase {
    DatabaseSession m_session;

    public SessionsXMLSchemaSunCORBATransportConfigTest() {
        this.setDescription("Test loading of a basic session xml that uses the SunCorbaTransportManagerConfig");
    }

    public void reset() {
        if (this.m_session != null) {
            if (this.m_session.isConnected()) {
                this.m_session.logout();
            }
            SessionManager.getManager().getSessions().remove(this.m_session);
            this.m_session = null;
        }
    }

    public void test() {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSession.xml");
        this.m_session = (DatabaseSession)SessionManager.getManager().getSession(loader, "SunCorbaTransportManager", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
    }

    protected void verify() {
        if (this.m_session == null) {
            throw new TestErrorException("The session read in was null");
        }
        TransportManager tm = this.m_session.getCommandManager().getTransportManager();
        if (!(tm instanceof SunCORBATransportManager)) {
            throw new TestErrorException("Transport manager was the wrong type");
        }
    }
}

